//
//  NMAAuthConnection.h
//  NMAAuthLib0
//
//  Created by iam on 7/10/15.
//  Copyright (c) 2015 NetIQ. All rights reserved.
//
//  OAuth2Client
//
//  Created by Ullrich Schäfer on 27.08.10.
//
//  Copyright 2010 nxtbgthng. All rights reserved.
//
//  Licenced under the new BSD-licence.
//  See README.md in this repository for
//  the full licence.
//

#import <Foundation/Foundation.h>

#import "NMAAuthConstant.h"

@class NMAAuthClient;
@protocol NMAAuthConnectionDelegate;


/*!
 *    The connection
 *
 *    NMAAuthConnection is a wrapper around NSURLConnection.
 *    It's main purpose is to simplify the delegates & to provide a context
 *    ivar that can be used to put a connection object in a certain context.
 *    The context may be compared to a tag.
 *
 *    NMAAuthConnection only provides asynchronous connections as synchronous
 *    connections are strongly discouraged.
 *
 *    The connection works together with the OAuth2 Client to sign a request
 *    before sending it. If no client is passed in the connection will sent
 *    unsigned requests.
 */


#ifndef NMAAuthConnectionDebug
#define NMAAuthConnectionDebug 0
#endif



extern NSString * const NMAAuthConnectionDidStartNotification;
extern NSString * const NMAAuthConnectionDidEndNotification;


typedef void(^NMAAuthConnectionResponseHandler)(NSURLResponse *response, NSData *responseData, NSError *error);
typedef void(^NMAAuthConnectionSendingProgressHandler)(unsigned long long bytesSend, unsigned long long bytesTotal);



@interface NMAAuthConnection : NSObject

@property (nonatomic, unsafe_unretained) NSObject<NMAAuthConnectionDelegate>    *delegate;
@property (nonatomic, strong, readonly) NSData *data;
@property (nonatomic, assign) BOOL savesData;
@property (nonatomic, assign, readonly) long long expectedContentLength;
@property (nonatomic, strong, readonly) NSURLResponse *response;
@property (nonatomic, assign, readonly) NSInteger statusCode;
@property (nonatomic, strong) id context;
@property (nonatomic, strong) NSDictionary *userInfo;
@property (nonatomic, strong, readonly) NMAAuthClient *client;

- (instancetype) initWithRequest:(NSMutableURLRequest *)request
               requestParameters:(NSDictionary *)requestParameters
                     oauthClient:(NMAAuthClient *)client
          sendingProgressHandler:(NMAAuthConnectionSendingProgressHandler)sendingProgressHandler
                 responseHandler:(NMAAuthConnectionResponseHandler)responseHandler;

- (instancetype)initWithRequest:(NSMutableURLRequest *)request
              requestParameters:(NSDictionary *)requestParameters
                    oauthClient:(NMAAuthClient *)client
                       delegate:(NSObject<NMAAuthConnectionDelegate> *)delegate;

- (void)cancel;

- (void)retry;

@end
