//
//  NMAAuthToken.h
//  NMAAuthLib0
//
//  Created by iam on 7/10/15.
//  Copyright (c) 2015 NetIQ. All rights reserved.
//
//  OAuth2Client
//
//  Created by Ullrich Schäfer on 27.08.10.
//
//  Copyright 2010 nxtbgthng. All rights reserved.
//
//  Licenced under the new BSD-licence.
//  See README.md in this repository for
//  the full licence.
//

#import <Foundation/Foundation.h>
#import <Security/Security.h>

@interface NMAAuthToken : NSObject <NSCoding>

@property (nonatomic, readonly) NSString *accessToken;
@property (nonatomic, readonly) NSString *refreshToken;
@property (nonatomic, readonly) NSString *tokenType;
@property (nonatomic, readonly) NSDate *expiresAt;
@property (nonatomic, readonly) BOOL doesExpire;
@property (nonatomic, readonly) BOOL hasExpired;
@property (nonatomic, readonly) NSSet *scope;
@property (nonatomic, readonly) NSString *responseBody;

+ (instancetype)tokenWithResponseBody:(NSString *)responseBody;

+ (instancetype)tokenWithResponseBody:(NSString *)responseBody
                            tokenType:(NSString *)tokenType;

- (instancetype)initWithAccessToken:(NSString *)accessToken;

- (instancetype)initWithAccessToken:(NSString *)accessToken
                       refreshToken:(NSString *)refreshToken
                          expiresAt:(NSDate *)expiryDate;

- (instancetype)initWithAccessToken:(NSString *)accessToken
                       refreshToken:(NSString *)refreshToken
                          expiresAt:(NSDate *)expiryDate
                              scope:(NSSet *)scope;

- (instancetype)initWithAccessToken:(NSString *)accessToken
                       refreshToken:(NSString *)refreshToken
                          expiresAt:(NSDate *)expiryDate
                              scope:(NSSet *)scope
                       responseBody:(NSString *)responseBody;

- (instancetype)initWithAccessToken:(NSString *)accessToken
                       refreshToken:(NSString *)refreshToken
                          expiresAt:(NSDate *)expiryDate
                              scope:(NSSet *)scope
                       responseBody:(NSString *)responseBody
                          tokenType:(NSString*)tokenType; // designated

- (void)restoreWithOldToken:(NMAAuthToken *)oldToken;

#pragma mark Keychain Support

//TODO: Support alternate KeyChain Locations
+ (instancetype)tokenFromDefaultKeychainWithServiceProviderName:(NSString *)provider
                                                withAccessGroup:(NSString *)accessGroup;

- (void)storeInDefaultKeychainWithServiceProviderName:(NSString *)provider
                                      withAccessGroup:(NSString *)accessGroup;

- (void)removeFromDefaultKeychainWithServiceProviderName:(NSString *)provider
                                         withAccessGroup:(NSString *)accessGroup;

@end
