//
//  NMAAuthTrustDelegate.h
//  NMAAuthLib0
//
//  Created by iam on 7/10/15.
//  Copyright (c) 2015 NetIQ. All rights reserved.
//
//  OAuth2Client
//
//  Created by Thomas Kollbach on 24.05.11.
//
//  Copyright 2011 nxtbgthng. All rights reserved.
//
//  Licenced under the new BSD-licence.
//  See README.md in this repository for
//  the full licence.
//

#import <Foundation/Foundation.h>

#import "NMAAuthConstant.h"

@class NMAAuthConnection;

/*!
 * The delegate of the NMAAuthConnection or the NMAAuthClient can both
 * optionally implement this protocol to ensure specific trust modes.
 *
 * If a NMAAuthConnection is created with a NMAAuthClient set and both
 * delegates conform to the NMAAuthTrustDelegate protocol, the NMAAuthClient's
 * delegate is used.
 */

@protocol NMAAuthTrustDelegate <NSObject>

@optional

/*!
 * Specifies Trust mode for the specific hostname. See NMAAuthConstant.h for constants
 */
-(NMAAuthTrustMode)connection:(NMAAuthConnection *)connection trustModeForHostname:(NSString *)hostname;

/*!
 * Array of NSData objects that contains the trusted certificates for the hostname.
 */
-(NSArray *)connection:(NMAAuthConnection *)connection trustedCertificatesForHostname:(NSString *)hostname;

@end
