//
//  NMAAuthAccount.h
//  NMAAuthLib0
//
//  Created by iam on 7/10/15.
//  Copyright (c) 2015 NetIQ. All rights reserved.
//
//  OAuth2Client
//
//  Created by Tobias Kräntzer on 12.07.11.
//
//  Copyright 2011 nxtbgthng. All rights reserved.
//
//  Licenced under the new BSD-licence.
//  See README.md in this repository for
//  the full licence.
//

#import <Foundation/Foundation.h>

@class NMAAuthClient;
@class NMAAuthToken;

#pragma mark Notifications

extern NSString * const NMAAuthAccountDidChangeUserDataNotification;
extern NSString * const NMAAuthAccountDidChangeAccessTokenNotification;
extern NSString * const NMAAuthAccountDidLoseAccessTokenNotification;
extern NSString * const NMAAuthAccountDidFailToGetAccessTokenNotification;

#pragma mark -

@interface NMAAuthAccount : NSObject {
@private
    NSString *accountName;
    NSString *identifier;
    id <NSObject, NSCoding, NSCopying> userData;
    NMAAuthClient *oauthClient;
    NMAAuthToken *accessToken;
}

#pragma mark Accessors

@property (nonatomic, copy, readonly) NSString *accountName;
@property (nonatomic, copy, readonly) NSString *identifier;
@property (nonatomic, copy) id <NSObject, NSCoding, NSCopying> userData;

@property (nonatomic, strong, readonly) NMAAuthClient *oauthClient;
@property (nonatomic, strong, readonly) NMAAuthToken *accessToken;

@end
