//
//  NMAAuthClientDelegate.h
//  NMAAuthLib0
//
//  Copyright (c) 2015 NetIQ. All rights reserved.
//
//  OAuth2Client
//
//  Created by Gernot Poetsch on 14.09.10.
//
//  Copyright 2010 nxtbgthng. All rights reserved.
//
//  Licenced under the new BSD-licence.
//  See README.md in this repository for
//  the full licence.
//

#import "NMAAuthConstant.h"
#import "NMAAuthTrustDelegate.h"

@class NMAAuthClient;

@protocol NMAAuthClientDelegate <NMAAuthTrustDelegate>

@required
/*!
 * When this is called on the delegate, you are supposed to invoke the appropriate authentication method in the client.
 */
- (void)oauthClientNeedsAuthentication:(NMAAuthClient *)client;

@optional
- (void)oauthClientDidGetAccessToken:(NMAAuthClient *)client;
- (void)oauthClientDidLoseAccessToken:(NMAAuthClient *)client;
- (void)oauthClientDidRefreshAccessToken:(NMAAuthClient *)client;
- (void)oauthClient:(NMAAuthClient *)client didFailToGetAccessTokenWithError:(NSError *)error;

@end