//
//  NMAAuthConnectionDelegate.h
//  NMAAuthLib0
//
//  Created by iam on 7/10/15.
//  Copyright (c) 2015 NetIQ. All rights reserved.
//
//  OAuth2Client
//
//  Created by Ullrich Schäfer on 27.08.10.
//
//  Copyright 2010 nxtbgthng. All rights reserved.
//
//  Licenced under the new BSD-licence.
//  See README.md in this repository for
//  the full licence.
//

#import "NMAAuthConstant.h"
#import "NMAAuthTrustDelegate.h"

@class NMAAuthConnection;


@protocol NMAAuthConnectionDelegate <NSObject, NMAAuthTrustDelegate>
@optional

/*!
 *    The connection did receive a response.
 *
 *    This method is not called if the response was a 401 with an expired token & a refresh token.
 *    If so, then the token is refreshed & the connection will be automagically retried.
 */
- (void)oauthConnection:(NMAAuthConnection *)connection didReceiveResponse:(NSURLResponse *)response;

/*!
 *    The connection did finish and recieved the whole data.
 */
- (void)oauthConnection:(NMAAuthConnection *)connection didFinishWithData:(NSData *)data;

/*!
 *    The connection did fail with an error
 *
 *    The domain of the error is NMAAuthErrorDomain.
 *    Check the error code to see if it's been an HTTP error (NMAAuthHTTPErrorCode). If so you can get the original error from the userInfo with the key NMAAuthHTTPErrorKey
 */
- (void)oauthConnection:(NMAAuthConnection *)connection didFailWithError:(NSError *)error;

/*!
 *    The connection recieved a new chunk of bytes.
 *
 *    Note: use connection.data.length and connection.expectedContentLength to get the overall progress
 */
- (void)oauthConnection:(NMAAuthConnection *)connection didReceiveData:(NSData *)data;

/*!
 *    The connection did send new data
 */
- (void)oauthConnection:(NMAAuthConnection *)connection didSendBytes:(unsigned long long)bytesSend ofTotal:(unsigned long long)bytesTotal;

/*!
 * The connection received a redirect response
 */
- (void)oauthConnection:(NMAAuthConnection *)connection didReceiveRedirectToURL:(NSURL *)redirectURL;


@end