//
//  NMAAuthRequest.h
//  NMAAuthLib0
//
//  Created by iam on 7/10/15.
//  Copyright (c) 2015 NetIQ. All rights reserved.
//
//  OAuth2Client
//
//  Created by Tobias Kräntzer on 13.07.11.
//
//  Copyright 2011 nxtbgthng. All rights reserved.
//
//  Licenced under the new BSD-licence.
//  See README.md in this repository for
//  the full licence.
//

#import <Foundation/Foundation.h>

#import "NMAAuthConnection.h"

@class NMAAuthAccount;


@interface NMAAuthRequest : NSObject {
@private
    NSDictionary *parameters;
    NSURL *resource;
    NSString *requestMethod;
    NMAAuthAccount *account;
    NMAAuthConnection *connection;
    NMAAuthRequest *me;
}

#pragma mark Class Methods

+ (void)performMethod:(NSString *)method
           onResource:(NSURL *)resource
      usingParameters:(NSDictionary *)parameters
          withAccount:(NMAAuthAccount *)account
  sendProgressHandler:(NMAAuthConnectionSendingProgressHandler)progressHandler
      responseHandler:(NMAAuthConnectionResponseHandler)responseHandler;


#pragma mark Lifecycle

- (instancetype)initWithResource:(NSURL *)url
                          method:(NSString *)method
                      parameters:(NSDictionary *)parameter;


#pragma mark Accessors

@property (nonatomic, strong, readwrite) NMAAuthAccount *account;

@property (nonatomic, strong, readwrite) NSString *requestMethod;
@property (nonatomic, strong, readwrite) NSURL *resource;
@property (nonatomic, strong, readwrite) NSDictionary *parameters;


#pragma mark authorize NSURLRequest

//- (NSURLRequest *)authorizeURLRequest;
- (NSURLRequest *)authorizeURLRequestWithError:(NSError **) error;


#pragma mark Perform Request

- (void)performRequestWithSendingProgressHandler:(NMAAuthConnectionSendingProgressHandler)progressHandler
                                 responseHandler:(NMAAuthConnectionResponseHandler)responseHandler;


#pragma mark Cancel

- (void)cancel;

@end
