// deleteAppmark.js is an example of using the AMService APIs to delete an appmark
// Run refreshIdpCluster.js after this for your changes to take effect
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4


// ACTION REQUIRED: Replace the appmarkId value below with the instanceID of the appmark you want to delete.
//                  See getAppmarks.js for an example of reading the instanceID of an appmark programatically.
var appmarkId = '2e0ae58b-711a-463b-a22a-222b623508d1';


require('./common').then(function(common) {

	// Sets up options for calling the API
	var options = {
	    host: common.host,
	    port: common.port,
	    path: '/amsvc/v1/idpclusters/' + common.clusterId + '/appmarks/' + appmarkId,
	    method: 'DELETE',
	    headers: {
	        'Authorization': common.authHeader,
	        'Accept': 'application/json'
	    }
	};

	// Calls the API and logs the result
	common.httpsRequest(options).then(function(response) {
		console.log(common.prettyJson(response.json ? response.json : response));

	}).catch(function(err) {
	    console.log('An error occurred calling the API to delete the appmark:', err);
	});

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});