// getAppmark.js is an example of using the AMService APIs to retrieve an appmark
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4


// ACTION REQUIRED: Replace the appmarkId value below with the instanceID of the appmark you want to read.
//                  See getAppmarks.js for an example of reading the instanceID of an appmark programatically.
var appmarkId = '448525b8-db33-4c09-9701-9896f596a411';


require('./common').then(function(common) {

    // Sets up options for calling the API
    var options = {
        host: common.host,
        port: common.port,
        path: '/amsvc/v1/idpclusters/' + common.clusterId + '/appmarks/' + appmarkId,
        method: 'GET',
        headers: {
            'Authorization': common.authHeader,
            'Accept': 'application/json'
        }
    };

    // Calls the API and logs the result
    common.httpsRequest(options).then(function(response) {
        console.log(common.prettyJson(response.json ? response.json : response));

    }).catch(function(err) {
        console.log('An error occurred calling the API to get the appmark:', err);
    });

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});