// getConnectorDefinition.js is an example of using the AMService APIs to retrieve a connector definition
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4


// ACTION REQUIRED: Replace the connectorDefinitionId value below with the instanceID of the connector definition you want to read.
//                  See getConnectorDefinitions.js for an example of reading the instanceID of a connector definition programatically.
var connectorDefinitionId = '28174020-9f21-4ac1-bf07-45da4cb6d565';


require('./common').then(function(common) {

	// Sets up options for calling the API
	var options = {
	    host: common.host,
	    port: common.port,
	    path: '/amsvc/v1/connectordefinitions/' + connectorDefinitionId,
	    method: 'GET',
	    headers: {
	        'Authorization': common.authHeader,
	        'Accept': 'application/json'
	    }
	};

	// Calls the API and logs the result
	common.httpsRequest(options).then(function(response) {
		console.log(common.prettyJson(response.json ? response.json : response));

	}).catch(function(err) {
	    console.log('An error occurred calling the API to get the connector definition:', err);
	});

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});