// getConnectorInstance.js is an example of using the AMService APIs to retrieve a connector instance
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4


// ACTION REQUIRED: Replace the connectorInstanceId value below with the connectorInstanceId of the connector instance you want to read.
//                  See getConnectorInstances.js for an example of reading the connectorInstanceId of a connector instance programatically.
var connectorInstanceId = 'c46d30ec-3be8-476f-93b7-8fea15f74584';


require('./common').then(function(common) {

	// Sets up options for calling the API
	var options = {
	    host: common.host,
	    port: common.port,
	    path: '/amsvc/v1/idpclusters/' + common.clusterId + '/connectorinstances/' + connectorInstanceId,
	    method: 'GET',
	    headers: {
	        'Authorization': common.authHeader,
	        'Accept': 'application/json'
	    }
	};

	// Calls the API and logs the result
	common.httpsRequest(options).then(function(response) {
		console.log(common.prettyJson(response.json ? response.json : response));

	}).catch(function(err) {
	    console.log('An error occurred calling the API to get the connector instance:', err);
	});

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});