// getConnectorInstances.js is an example of using the AMService APIs to retrieve a list of connector instances
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4

require('./common').then(function(common) {

	// Sets up options for calling the API
	var options = {
	    host: common.host,
	    port: common.port,
	    path: '/amsvc/v1/idpclusters/' + common.clusterId + '/connectorinstances',
	    method: 'GET',
	    headers: {
	        'Authorization': common.authHeader,
	        'Accept': 'application/json'
	    }
	};

	// Calls the API and logs the result
	common.httpsRequest(options).then(function(response) {
		console.log(common.prettyJson(response.json ? response.json : response));

		// Now that we've retrieved the list of connector instances, the following is an example of how to get
		// the instance ID of a connector instance if we know the display name.
		var displayName = 'Salesforce';
		if (response.statusCode >= 200 && response.statusCode < 300 && response.json) {
			console.log('\n', displayName, 'connector instance has instance ID:', getConnectorInstanceIdByDisplayName(response.json, displayName));
		}

	}).catch(function(err) {
	    console.log('An error occurred calling the API to list the connector instances:', err);
	});

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});

// Returns the instanceID of the trusted service provider that has the given displayName, or undefined if none match.
function getConnectorInstanceIdByDisplayName(amServiceResponseDoc, displayName) {
	for (var i = 0; i < amServiceResponseDoc.connectorInstanceList.connectorInstance.length; i++) {
  		if (amServiceResponseDoc.connectorInstanceList.connectorInstance[i].displayName === displayName) {
    		return amServiceResponseDoc.connectorInstanceList.connectorInstance[i].connectorInstanceId;
  		}
	}
  	return undefined;
}