// getIdpClusters.js is an example of using the AMService APIs to retrieve a list of IDP clusters
// A similar example is included in common.js
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4

require('./common').then(function(common) {

    // Sets up options for calling the API
    var options = {
        host: common.host,
        port: common.port,
        path: '/amsvc/v1/idpclusters',
        method: 'GET',
        headers: {
            'Authorization': common.authHeader,
            'Accept': 'application/json'
        }
    };

    // Calls the API and logs the result
    common.httpsRequest(options).then(function(response) {
        console.log(common.prettyJson(response.json ? response.json : response));

        // Now that we've retrieved the list of IDP clusters, the following is an example of how to get
        // the instance ID of a cluster if we know the display name.
        var displayName = 'cluster1';
        if (response.statusCode >= 200 && response.statusCode < 300 && response.json) {
            console.log('\n', displayName, 'cluster has instance ID:', getClusterInstanceIdByDisplayName(response.json, displayName));
        }

    }).catch(function(err) {
        console.log('An error occurred calling the API to list the IDP clusters:', err);
    });

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});

// Returns the instanceID of the IDP cluster that has the given displayName, or undefined if none match.
function getClusterInstanceIdByDisplayName(amServiceResponseDoc, displayName) {
    for (var i = 0; i < amServiceResponseDoc.idpClusterList.idpCluster.length; i++) {
        if (amServiceResponseDoc.idpClusterList.idpCluster[i].displayName === displayName) {
            return amServiceResponseDoc.idpClusterList.idpCluster[i].instanceID;
        }
    }
    return undefined;
}