// refreshIdpCluster.js is an example of using the AMService APIs to update/refresh the configuration of all IDP devices in a cluster.
// An IDP's configuration must be updated/refreshed after making changes through the APIs in order for those changes to take effect.
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4

require('./common').then(function(common) {

    // Sets up options for calling the API to read the device list from the IDP cluster
    var options = {
        host: common.host,
        port: common.port,
        path: '/amsvc/v1/idpclusters/' + common.clusterId + '/devices',
        method: 'GET',
        headers: {
            'Authorization': common.authHeader,
            'Accept': 'application/json'
        }
    };

    common.httpsRequest(options).then(function(response) {
    	console.log(common.prettyJson(response.json ? response.json : response));
    	if (response.statusCode >= 200 && response.statusCode < 300 && response.json) {
    		for (var i = 0; i < response.json.idpDeviceList.idpDevice.length; i++) {
    			updateIdpConfig(response.json.idpDeviceList.idpDevice[i]);
    		}
    	}
    }).catch(function(err) {
        console.log('An error occurred calling the API to list devices in the IDP cluster:', err);
    });

	function updateIdpConfig(device) {
		if (device.healthStatus !== 'Green') {
			console.log('WARNING: The IDP ' + device.displayName + ' has a health status of "' + device.healthStatus + '".');
			console.log('The configuration update will be attempted, but may not succeed.');
		}

	    // Sets up options for calling the API to update an IDP's configuration
	    var options = {
	        host: common.host,
	        port: common.port,
	        path: '/amsvc/v1/idpclusters/' + common.clusterId + '/devices/' + device.instanceID,
	        method: 'PUT',
	        headers: {
	            'Authorization': common.authHeader,
	            'Accept': 'application/json',
	            'Content-Type': 'application/json ; charset=UTF-8'
	        }
	    };

		common.httpsRequest(options, '{"update":"all"}').then(function(response) {
			console.log(common.prettyJson(response.json ? response.json : response));
		}).catch(function(err) {
			console.log('An error occurred calling the API to update the configuration for IDP device ' + device.displayName + ':', err);
		});
	}

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});