/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe.kdf;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.UncheckedJoseException;

public class ConcatKeyDerivationFunction {
    Log log = LogFactory.getLog(this.getClass());
    private int digestLength;
    private MessageDigest messageDigest;

    public ConcatKeyDerivationFunction(String hashAlgoritm) {
        this.messageDigest = this.getMessageDigest(hashAlgoritm);
        this.digestLength = ByteUtil.bitLength(this.messageDigest.getDigestLength());
        this.log.debug((Object)("Hash Algorithm: " + hashAlgoritm + " with hashlen: " + this.digestLength + " bits"));
    }

    public byte[] kdf(byte[] sharedSecret, int keydatalen, byte[] algorithmId, byte[] partyUInfo, byte[] partyVInfo, byte[] suppPubInfo, byte[] suppPrivInfo) {
        this.log.debug((Object)"KDF:");
        this.log.debug((Object)("  z: " + ByteUtil.toDebugString(sharedSecret)));
        this.log.debug((Object)("  keydatalen: " + keydatalen));
        this.log.debug((Object)("  algorithmId: " + ByteUtil.toDebugString(algorithmId)));
        this.log.debug((Object)("  partyUInfo: " + ByteUtil.toDebugString(partyUInfo)));
        this.log.debug((Object)("  partyVInfo: " + ByteUtil.toDebugString(partyVInfo)));
        this.log.debug((Object)("  suppPubInfo: " + ByteUtil.toDebugString(suppPubInfo)));
        this.log.debug((Object)("  suppPrivInfo: " + ByteUtil.toDebugString(suppPrivInfo)));
        byte[] otherInfo = ByteUtil.concat(algorithmId, partyUInfo, partyVInfo, suppPubInfo, suppPrivInfo);
        return this.kdf(sharedSecret, keydatalen, otherInfo);
    }

    public byte[] kdf(byte[] sharedSecret, int keydatalen, byte[] otherInfo) {
        long reps = this.getReps(keydatalen);
        this.log.debug((Object)("reps: " + reps));
        this.log.debug((Object)("otherInfo: " + ByteUtil.toDebugString(otherInfo)));
        ByteArrayOutputStream derivedByteOutputStream = new ByteArrayOutputStream();
        int i = 1;
        while ((long)i <= reps) {
            this.log.debug((Object)("rep " + i + " hashing "));
            byte[] counterBytes = ByteUtil.getBytes(i);
            this.log.debug((Object)(" counter: " + ByteUtil.toDebugString(counterBytes)));
            this.log.debug((Object)(" z: " + ByteUtil.toDebugString(sharedSecret)));
            this.log.debug((Object)(" otherInfo: " + ByteUtil.toDebugString(otherInfo)));
            this.messageDigest.update(counterBytes);
            this.messageDigest.update(sharedSecret);
            this.messageDigest.update(otherInfo);
            byte[] digest = this.messageDigest.digest();
            this.log.debug((Object)(" k(" + i + "): " + ByteUtil.toDebugString(digest)));
            derivedByteOutputStream.write(digest, 0, digest.length);
            ++i;
        }
        int keyDateLenInBytes = ByteUtil.byteLength(keydatalen);
        byte[] derivedKeyMaterial = derivedByteOutputStream.toByteArray();
        this.log.debug((Object)("derived key material: " + ByteUtil.toDebugString(derivedKeyMaterial)));
        if (derivedKeyMaterial.length != keyDateLenInBytes) {
            byte[] newKeyMaterial = ByteUtil.subArray(derivedKeyMaterial, 0, keyDateLenInBytes);
            this.log.debug((Object)("first " + keydatalen + " bits of derived key material: " + ByteUtil.toDebugString(newKeyMaterial)));
            derivedKeyMaterial = newKeyMaterial;
        }
        this.log.debug((Object)("final derived key material: " + ByteUtil.toDebugString(derivedKeyMaterial)));
        return derivedKeyMaterial;
    }

    long getReps(int keydatalen) {
        double repsD = (float)keydatalen / (float)this.digestLength;
        repsD = Math.ceil(repsD);
        return (int)repsD;
    }

    private MessageDigest getMessageDigest(String digestMethod) {
        try {
            return MessageDigest.getInstance(digestMethod);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedJoseException("Must have " + digestMethod + " MessageDigest but don't.", e);
        }
    }
}

