/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwk;

import java.io.Serializable;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.JsonHelp;

public abstract class JsonWebKey
implements Serializable {
    public static final String KEY_TYPE_PARAMETER = "kty";
    public static final String USE_PARAMETER = "use";
    public static final String KEY_ID_PARAMETER = "kid";
    public static final String ALGORITHM_PARAMETER = "alg";
    private String use;
    private String keyId;
    private String algorithm;
    protected Key key;

    protected JsonWebKey(Key key) {
        this.key = key;
    }

    protected JsonWebKey(Map<String, Object> params) {
        this.setUse(JsonHelp.getString(params, USE_PARAMETER));
        this.setKeyId(JsonHelp.getString(params, KEY_ID_PARAMETER));
        this.setAlgorithm(JsonHelp.getString(params, ALGORITHM_PARAMETER));
    }

    public abstract String getKeyType();

    protected abstract void fillTypeSpecificParams(Map<String, Object> var1, OutputControlLevel var2);

    public PublicKey getPublicKey() {
        try {
            return (PublicKey)this.key;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Key getKey() {
        return this.key;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Map<String, Object> toParams(OutputControlLevel outputLevel) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(KEY_TYPE_PARAMETER, this.getKeyType());
        this.putIfNotNull(KEY_ID_PARAMETER, this.getKeyId(), params);
        this.putIfNotNull(USE_PARAMETER, this.getUse(), params);
        this.putIfNotNull(ALGORITHM_PARAMETER, this.getAlgorithm(), params);
        this.fillTypeSpecificParams(params, outputLevel);
        return params;
    }

    public String toJson() {
        return this.toJson(OutputControlLevel.INCLUDE_SYMMETRIC);
    }

    public String toJson(OutputControlLevel outputLevel) {
        Map<String, Object> params = this.toParams(outputLevel);
        return JsonUtil.toJson(params);
    }

    public String toString() {
        return this.getClass().getName() + this.toParams(OutputControlLevel.PUBLIC_ONLY);
    }

    protected void putIfNotNull(String name, String value, Map<String, Object> params) {
        if (value != null) {
            params.put(name, value);
        }
    }

    public static class Factory {
        public static JsonWebKey newJwk(Map<String, Object> params) throws JoseException {
            String kty = JsonHelp.getString(params, JsonWebKey.KEY_TYPE_PARAMETER);
            if ("RSA".equals(kty)) {
                return new RsaJsonWebKey(params);
            }
            if ("EC".equals(kty)) {
                return new EllipticCurveJsonWebKey(params);
            }
            if ("oct".equals(kty)) {
                return new OctetSequenceJsonWebKey(params);
            }
            throw new JoseException("Unknown key algorithm: '" + kty + "'");
        }

        public static JsonWebKey newJwk(Key key) throws JoseException {
            if (RSAPublicKey.class.isInstance(key)) {
                return new RsaJsonWebKey((RSAPublicKey)key);
            }
            if (ECPublicKey.class.isInstance(key)) {
                return new EllipticCurveJsonWebKey((ECPublicKey)key);
            }
            if (PublicKey.class.isInstance(key)) {
                throw new JoseException("Unsupported or unknown public key " + key);
            }
            return new OctetSequenceJsonWebKey(key);
        }

        public static JsonWebKey newJwk(String json) throws JoseException {
            Map<String, Object> parsed = JsonUtil.parseJson(json);
            return Factory.newJwk(parsed);
        }
    }

    public static enum OutputControlLevel {
        INCLUDE_PRIVATE,
        INCLUDE_SYMMETRIC,
        PUBLIC_ONLY;

    }
}

