/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2SsoCondition;
import org.springframework.boot.autoconfigure.security.oauth2.client.SsoSecurityConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Configuration
@Conditional(value={NeedsWebSecurityCondition.class})
public class OAuth2SsoDefaultConfiguration
extends WebSecurityConfigurerAdapter {
    private final ApplicationContext applicationContext;

    public OAuth2SsoDefaultConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/**").authorizeRequests().anyRequest()).authenticated();
        new SsoSecurityConfigurer(this.applicationContext).configure(http);
    }

    protected static class NeedsWebSecurityCondition
    extends EnableOAuth2SsoCondition {
        protected NeedsWebSecurityCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ConditionOutcome.inverse((ConditionOutcome)super.getMatchOutcome(context, metadata));
        }
    }
}

