/*
 * Copyright 2018 NetIQ Corporation, a Micro Focus company.
 */
package com.microfocus.am.oauth.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties
/** 
 * Reads the application.yaml settings and makes them available to the application.
 * 
 */
public class AppConfig {
  
	@Value("${security.oauth2.client.userAuthorizationUri}")
	private String authorizationEndpointURL;
	
	@Value("${security.oauth2.client.accessTokenUri}")
	private String tokenEndpointURL;
	
	@Value("${security.oauth2.client.tokenInfoUri}")
	private String tokenInfoEndpointURL;
	
	@Value("${security.oauth2.resource.userInfoUri}")
	private String userInfoEndpointURL;
	
	@Value("${security.oauth2.client.preEstablishedRedirectUri}")
	private String redirectURI;
	
	@Value("${security.oauth2.client.clientId}")
	private String clientId;
	
	@Value("${security.oauth2.client.clientSecret}")
	private String clientSecret;

	public String getAuthorizationEndpointURL() {
		return authorizationEndpointURL;
	}

	public void setAuthorizationEndpointURL(String authorizationEndpointURL) {
		this.authorizationEndpointURL = authorizationEndpointURL;
	}

	public String getTokenEndpointURL() {
		return tokenEndpointURL;
	}

	public void setTokenEndpointURL(String tokenEndpointURL) {
		this.tokenEndpointURL = tokenEndpointURL;
	}

	public String getTokenInfoEndpointURL() {
		return tokenInfoEndpointURL;
	}

	public void setTokenInfoEndpointURL(String tokenInfoEndpointURL) {
		this.tokenInfoEndpointURL = tokenInfoEndpointURL;
	}

	public String getUserInfoEndpointURL() {
		return userInfoEndpointURL;
	}

	public void setUserInfoEndpointURL(String userInfoEndpointURL) {
		this.userInfoEndpointURL = userInfoEndpointURL;
	}

	public String getRedirectURI() {
		return redirectURI;
	}

	public void setRedirectURI(String redirectURI) {
		this.redirectURI = redirectURI;
	}

	public String getClientId() {
		return clientId;
	}

	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	public String getClientSecret() {
		return clientSecret;
	}

	public void setClientSecret(String clientSecret) {
		this.clientSecret = clientSecret;
	}
	
	
 
}
