/*
 * Copyright 2018 NetIQ Corporation, a Micro Focus company.
 */
package com.microfocus.am.oauth.config;

import org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2Sso;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@Configuration
@EnableOAuth2Sso
/**
 * Configures the security policies for various access URLs.
 * Also the @EnableOAuth2Sso annotation above marks this as a Spring Oauth client.
 * Spring OAuth automatically turns on their features for making this as an client.
 * 
 */
public class SecurityConfig extends  WebSecurityConfigurerAdapter {

    @Override
    protected void configure(HttpSecurity http) throws Exception 
    {
        http.antMatcher("/**")
            .authorizeRequests()
            .antMatchers("/","/callback**", "/login**", "/webjars/**", "/error**", "/**/*.html")
            .permitAll()
            .anyRequest()
            .authenticated();
    }
}
