#!/bin/bash
clear

cd sampleScripts/
echo -en '\E[47;46m'"\033[1m  Starting Automated Test for OAuth Try Now ............... \033[0m" 
echo ""
touch result_summary.txt
touch result_details.txt
echo "---------- Test Automation Summary report - for OAuth Try Now -----------" > result_summary.txt
echo "---------- Test Automation Detailed Output - for OAuth Try Now -----------" > result_details.txt
echo "Date and Time: `date`" >> "sampleScripts/result_summary.txt"
echo "Date and Time: `date`" >> "sampleScripts/result_details.txt"
echo "" >> result_summary.txt 
echo "" >> result_details.txt

export count=0
for i in $( ls *.sh);
do
file=$(cat $i)
cmpfile1=$(echo $i | cut -d"/" -f3)
#echo "-------- Executing testcase $cmpfile1 ----------"
echo -e '\E[37;44m'"\033[1m  ----------- Executing testcase $cmpfile1 ---------- \033[0m"
echo ""
chmod 755 $i
sh $i
#echo "value of i is "$i
count=$[$count + 1]
echo "count is $count"
done

total_no_of_testcases_passed=`grep :PASSED result_summary.txt | wc -l`
total_no_of_testcases_failed=`grep :FAILED result_summary.txt | wc -l`
echo "" >> result_summary.txt
cat result_summary.txt | grep FAILED > /dev/null 
if [ $? -eq 0 ]
then
  	echo -en '\E[47;41m'"\033[1m  Some or all of the Testcase in OAuth Try Now --  FAILED    \033[0m" 
	echo "Some or All Testcase in OAuth Try Now -- FAILED" >> result_summary.txt
else
  	echo -en '\E[47;42m'"\033[1m  All the Testcase in OAuth Try Now --  PASSED   \033[0m" 
	echo "All the Testcase in OAuth Try Now --  PASSED" >> result_summary.txt
fi
echo ""
echo "Total number of test cases EXECUTED in OAuth Try Now is: $count" 
echo "Total number of test cases PASSED in OAuth Try Now is: $total_no_of_testcases_passed" 
echo "Total number of test cases FAILED in OAuth Try Now is: $total_no_of_testcases_failed" 
echo ""
echo -en '\E[47;46m'"\033[1m  End of test: for OAuth Try Now \033[0m" 
echo "" >> result_summary.txt
echo "Date and Time: `date`" >> result_summary.txt
echo "------------ End of test - for OAuth Try Now ------------" >> result_summary.txt
echo "" >> result_summary.txt
echo ""
cp result_summary.txt result_summary_sampleScripts.txt 
mv result_summary_sampleScripts.txt ../../reports/.
cd ..
