#!/bin/sh
#Input Parameter File Name.

. ./config.txt

testcase=$0

# Login using credentials
curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

# Request for authorization code
curl -v -b c -c c -k "$authcodeurl"'?response_type=code&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'' -L > temp1 2>&1

#Retrieve Authorization Code from previous output
authzcode=`grep Location temp1 | cut -d'?' -f2 | cut -d'=' -f2 | cut -d'&' -f1`
authzcode=`echo $authzcode | sed -e 's/\r*$//g'`
binary
# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "OP/IDP  Initiated logout with front channel logout URI and sid configured for a client application, when user is logged in through a client application using Authorization Code flow " >> $result_details
echo "" >> $result_details

echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret " >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details

echo "" >> $result_details
echo "auth code is: $authzcode " >> $result_details
echo "" >> $result_details

#get token
curl -v -b c -c c -k -L -X POST -d 'grant_type=authorization_code&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'&code='"${authzcode}" "$grant_url" -o curloutput

#grep for access token and move the token value to result_details
token_access=`cat curloutput | jq ".access_token" |  cut -d\" -f2`
echo " Token output is : $token_access " >> $result_details

#print other json output as part of Access token. Store all values
token_refresh=`cat curloutput | jq ".refresh_token" |  cut -d\" -f2`
echo " refresh token value is : $token_refresh " >> $result_details
echo "" >> $result_details


#IDP/OP initiated global/Single Logout

curl -v -b c -c c -k "$logout_endpoint" -L > temp 2>&1

fclogout_uri_output=$(grep  "iframe" temp | awk -F"\"" '{print $2}' | awk -F"?" '{print $1}')
echo " front channel logout URI received: $fclogout_uri_output " >> $result_details
echo "" >> $result_details


session_token=$(grep  "iframe" temp | awk -F"sid=" '{print $2}' | awk -F"\"" '{print $1}' |  awk -F"&" '{print $1}')
echo " session token : $session_token " >> $result_details
echo "" >> $result_details


StatusCode=`cat temp | grep '< HTTP/1.1 200' | cut -d' ' -f3 | sed -e 's/\r*$//g'`
echo "status code is:"$StatusCode >> $result_details
echo "" >> $result_details


iss=$(grep  "iframe" temp | awk -F"iss=" '{print $2}' | awk -F"\"" '{print $1}')
echo " issuer is : $iss " >> $result_details
echo "" >> $result_details

echo -n $testcase":" >> $result_summary
if [ "$StatusCode" == '200' ] && [ "$fclogout_uri_output" == "https://gmail.logout.com" ] && [ "$session_token" != " " ] && [ "$iss" == $issuer ];
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi

rm curloutput temp1
rm temp
