#!/bin/sh

#Input Parameter File Name.

. ./config.txt

testcase=$0
state=test

# Login using credentials
curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L


# Request for authorization code
curl -v -b c -c c -k "$authcodeurl"'?response_type=code&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri""&scope=openid&nonce=mynonce" -L > temp1 2>&1
#Retrieve Authorization Code from previous output
authzcode=`grep Location temp1 | cut -d'?' -f2 | cut -d'=' -f2 | cut -d'&' -f1`
authzcode=`echo $authzcode | sed -e 's/\r*$//g'`


# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo " RP/Client application initiated logout using id_token_hint,state and post_logout_redirect_uri in the logout request-when user is logged in through client application using Authorization code flow ">> $result_details
echo "" >> $result_details


#get token
curl -v -b c -c c -k -L -X POST -d 'grant_type=authorization_code&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'&code='"${authzcode}" "$grant_url" -o curloutput

#grep for access token and move the token value to result_details
token_access=`cat curloutput | jq ".access_token" |  cut -d\" -f2`
echo " acess token  is : $token_access " >> $result_details

#print other json output as part of Access token. Store all values
token_refresh=`cat curloutput | jq ".refresh_token" |  cut -d\" -f2`
echo " refresh token  is : $token_refresh " >> $result_details


id_token=`cat curloutput | jq ".id_token" |  cut -d\" -f2`
echo "id token  is : $id_token " >> $result_details


#RP Initiated logout  with id_token_hint+post_logout_redirect_uri+state  in the logout request and selecting Accept in consent screen

curl -v -b c -c c -k "$session_endpoint"'?id_token_hint='"$id_token"'&state='"$state"'&post_logout_redirect_uri='"$post_logout_redirect_uri" -X POST -d 'consentStatus=Accept&multiBrowserSession=no' -L > temp 2>&1



post_logout_redirect_uri_with_state=`cat temp | grep '< Location: https://client.example.org/callback' | cut -d' ' -f3 | sed -e 's/\r*$//g'`
echo "post logout redirect uri with state:"$post_logout_redirect_uri_with_state >> $result_details
echo "" >> $result_details


# Print test case is passed or failed
echo -n $testcase":" >> $result_summary

if [ "$post_logout_redirect_uri_with_state" == $post_logout_redirect_uri"?state=test" ];
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi


rm curloutput  temp1
rm temp 

