#!/bin/sh
#Input Parameter File Name.

. ./config.txt

testcase=$0
state=netiq

# Login using credentials
curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

# Request for authorization code
curl -v -b c -c c -k "$authcodeurl"'?response_type=code&&client_id='"$client_id"'&state='"$state"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri" -L > temp 2>&1

#Retrieve Authorization Code from previous output
authzcode=`grep code= temp | awk -F: '{print $1}'| awk -F? '{print $2}' | awk -F= '{print $2}' | cut -d' ' -f1` 
authzcode=`echo $authzcode | sed -e 's/ *$//g'`
get_state=`grep Location: temp | awk -F"=" '{print $2}'| awk -F"\&" '{print $2}'`

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Optional parameter(State) - define state and validate the response in token" >> $result_details
echo "" >> $result_details

echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details

echo "" >> $result_details
echo "auth code is: $authzcode " >> $result_details

echo "" >> $result_details

echo "state returned during auth code is : $get_state" >> $result_details
echo "" >> $result_details

#Access token retrieve using Post request
curl -v -b c -c c -k -L -X POST -d 'grant_type=authorization_code&client_id='"$client_id"'&client_secret='"$client_secret"'&state='"$state"'&redirect_uri='"$redirect_uri"'&code='"${authzcode}" "$grant_url" -o curloutput

#grep for access token and move the token value to result_details
token_access=`cat curloutput | jq ".access_token" |  cut -d\" -f2`
echo "Access Token value is : $token_access " >> $result_details
echo "" >> $result_details

#print other json output as part of Access token. Store all values
token_refresh=`cat curloutput | jq ".refresh_token" |  cut -d\" -f2`
echo "refresh token value is : $token_refresh " >> $result_details
echo "" >> $result_details

expires_in=`cat curloutput | jq ".expires_in" |  cut -d\" -f2`
echo "expires_in value is : $expires_in " >> $result_details
echo "" >> $result_details

token_type=`cat curloutput | jq ".token_type" |  cut -d\" -f2`
echo "token_type value is : $token_type " >> $result_details
echo "" >> $result_details

echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$token_access"!="" ] && [ "$token_refresh"!="" ] ;
then
	echo "PASSED" >>  $result_summary
else
	echo "FAILED" >>  $result_summary
fi


#Remove all temporary files used by this script
rm temp
#rm curloutput
rm c
rm output-json
rm testresultfile
