#!/bin/sh
#Input Parameter File Name.

. ./config.txt

testcase=$0

# Login using credentials
curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

# Request for authorization code
curl -v -b c -c c -k "$authcodeurl"'?response_type=code&&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'&scope=claim1+claim2+scope3' -L > temp 2>&1

#Retrieve Authorization Code from previous output
authzcode=`grep code= temp | awk -F: '{print $1}'| awk -F? '{print $2}' | awk -F= '{print $2}' | awk -F"&" '{print $1}' | cut -d' ' -f1`
authzcode=`echo $authzcode | sed -e 's/ *$//g'`

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Validate claims in jwt using Resource server keys. " >> $result_details
echo "" >> $result_details

echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details
echo "" >> $result_details
echo "auth code is: $authzcode " >> $result_details
echo "" >> $result_details

#get token
curl -v -b c -c c -k -L -X POST -d 'grant_type=authorization_code&client_id='"$client_id"'&client_secret='"$client_secret"'&resourceServer=Demo_Resource_server&redirect_uri='"$redirect_uri"'&code='"${authzcode}" "$grant_url" -o curloutput

#grep for access token and move the token value to result_details
token_access=`cat curloutput | jq ".access_token" |  cut -d\" -f2`
echo " Token output is : $token_access " >> $result_details

#print other json output as part of Access token. Store all values
token_refresh=`cat curloutput | jq ".refresh_token" |  cut -d\" -f2`
echo " refresh token value is : $token_refresh " >> $result_details
echo "" >> $result_details

expires_in=`cat curloutput | jq ".expires_in" | cut -d':' -f2`
echo " expires_in value is : $expires_in " >> $result_details
echo "" >> $result_details

token_type=`cat curloutput | jq ".token_type" | cut -d':' -f2`
echo " token_type value is : $token_type " >> $result_details
echo "" >> $result_details

echo " ----------------------------------------------------------------------------------------------------------------" >>  $result_details

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary

if [ -f "curloutput" ]
then
        output=""

        cd decryptToken/
        sh create-input-file_only_signed.sh $token_access
        sh -vx idtd.sh < input-file > output
        cd ..
        cat decryptToken/output >> $result_details
	issuer=`cat decryptToken/output | grep iss |  jq ".iss" | awk -F'"' '{print $2}'`
        sub=`cat decryptToken/output | grep iss |  jq ".sub" | awk -F'"' '{print $2}'`
        aud=`cat decryptToken/output | grep iss |  jq ".aud" | awk -F'"' '{print $2}'`
        exp=`cat decryptToken/output | grep iss |  jq ".exp" `
        iat=`cat decryptToken/output | grep iss |  jq ".iat" `
        nonce=`cat decryptToken/output | grep iss |  jq ".nonce" | awk -F'"' '{print $2}'`
        output=`cat decryptToken/output | grep -i "Signature verified successfully" | awk -F":" '{print $2}'`
        if [  "$output" == "Signature verified successfully" ]
        then
		if [ "$issuer" != "" ] && [ "$sub" != "" ] && [ "$aud" != "" ] && [ "$exp" != "" ] && [ "$iat" != "" ] 
		then
	                echo "PASSED" >>  $result_summary
        	else
                	echo "FAILED" >>  $result_summary
	        fi
	else
		echo "FAILED" >> $result_summary
	fi
	else
        	echo "File doesn't exist"
	        echo "FAILED" >>  $result_summary
        	exit;
fi


#remove temporary files
rm temp curloutput c output-json out-result testresultfile
