#!/bin/sh
#Input Parameter File Name.

. ./config.txt

testcase=$0

# Login using credentials
curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

# Request for authorization code
curl -v -b c -c c -k "$authcodeurl"'?response_type=code&&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri" -L > temp 2>&1

#Retrieve Authorization Code from previous output
authzcode=`grep code= temp | awk -F: '{print $1}'| awk -F? '{print $2}' | awk -F= '{print $2}' | cut -d' ' -f1` 
authzcode=`echo $authzcode | sed -e 's/ *$//g'`

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Access token retrieval using refresh token without scope parameter " >> $result_details
echo "" >> $result_details
echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details
echo "" >> $result_details
echo "auth code is: $authzcode " >> $result_details
echo "" >> $result_details

#Access token retrieve using Post request
curl -v -b c -c c -k -L -X POST -d 'grant_type=authorization_code&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'&code='"${authzcode}" "$grant_url" -o curloutput

#grep for access token and move the token value to result_details
token_access=`cat curloutput | jq ".access_token" | cut -d\" -f2 | sed -e 's/ *$//g'` 
echo " Access Token value is : $token_access " >> $result_details
echo "" >> $result_details

#print other json output as part of Access token. Store all values
token_refresh=`cat curloutput | jq ".refresh_token" | cut -d\" -f2 | sed -e 's/ *$//g'`
echo " refresh token value is : $token_refresh " >> $result_details
echo "" >> $result_details

expires_in=`cat curloutput | jq ".expires_in" | cut -d\" -f2 | sed -e 's/ *$//g'`
echo " expires_in value is : $expires_in " >> $result_details
echo "" >> $result_details

token_type=`cat curloutput | jq ".token_type" | cut -d\" -f2 | sed -e 's/ *$//g'`
echo " token_type value is : $token_type " >> $result_details
echo "" >> $result_details

echo "Get the new Access token using Refresh token" >> $result_details

curl -v -b c -c c -k -L -X POST -d 'grant_type=refresh_token&client_id='"$client_id"'&client_secret='"$client_secret"'&refresh_token='"$token_refresh" "$grant_url" -o token_output

token_access_new=`cat token_output | jq ".access_token" | cut -d\" -f2 | sed -e 's/ *$//g'`
echo " New Access Token value is : $token_access_new " >> $result_details
echo "" >> $result_details

token_refresh_new=`cat token_output | jq ".refresh_token" | cut -d\" -f2 | sed -e 's/ *$//g'`
echo " New refresh token value is : $token_refresh_new " >> $result_details
echo "" >> $result_details

echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$token_access_new" != "" ] && [ "$token_refresh_new" != "" ];
then
	echo "PASSED" >>  $result_summary
else
	echo "FAILED" >>  $result_summary
fi


#Remove all temporary files used by this script
rm temp curloutput c output-json testresultfile
rm output-json1 token_output testresultfile1
