#!/bin/sh

echo "###########Load Local Configuration###########"

. ./config.txt

testcase=$0

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "" >> $result_details
echo " Test Case Description: Client Credentials Flow_mandatory field - Validate Response: Validate response output when all parameter is valid ">> $result_details
echo "" >> $result_details
echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details
echo "" >> $result_details

#Send Request with valid grant_type using POST 
curl -v -k -X POST -d 'grant_type=client_credentials&client_id='"$client_id"'&client_secret='"$client_secret" "$cc_url" -o curl_outputfile

#Get access token value
token_access=`cat curl_outputfile | jq ".access_token" | cut -d\" -f2`
echo "access token value is : $token_access " >> $result_details
echo "" >> $result_details

token_type=`cat curl_outputfile | jq ".token_type" | cut -d\" -f2`
echo "token_type value is: $token_type" >> $result_details
echo "" >> $result_details

expires_in=`cat curl_outputfile | jq ".expires_in" | cut -d\" -f2`
echo "token lifetime is : $expires_in" >> $result_details
echo "" >> $result_details


echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$token_access" != "" ] && [ "$token_type" == "bearer" ] && [ "$expires_in" != "300" ]
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi


#Remove all temporary files used by this script
rm curl_outputfile
rm json_outputfile


