#!/bin/sh
#Load Configuration Data
. ./config.txt

#Get test case name
testcase=$0

#Variable declaration
count=0
resource="resource_to_delete"

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Test to register scope " >> $result_details
echo "username is: $scope_username " >> $result_details
echo "password is: $scope_password " >> $result_details
echo "Scope is: $scope_full " >> $result_details
echo "" >> $result_details

# Login using credentials
curl -v -c c -b c -k -X POST -d 'option=credential&Ecom_User_ID='"$scope_username"'&Ecom_Password='"$scope_password" "$loginurl" -L

# Create a resource server
curl -v -b c -k -H "Content-Type: application/json" -X POST -d '{"name":"'$resource'"}'  $resource_server_url -o curloutput

echo $curloutput >> $result_details
echo "" >> $result_details

resource_name=`cat curloutput |  jq ".name" | cut -d\" -f2`
echo $resource_name >> $result_details
echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

echo  "$resource_server_url"'/'"$resource"

# Delete the resource
curl -v -b c -k -X DELETE "$resource_server_url"'/'"$resource" -o curloutput

# Evaluating the output
check_output=`cat curloutput |  jq ".status" | cut -d\" -f2`

#Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$check_output" == "successfully deleted the resource server" ]
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi


#Remove all temporary files used by this script
rm curloutput
