#!/bin/sh
#Input Parameter File Name.

. ./config.txt

curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

curl -v -b c -c c -k "$authcodeurl"'?response_type=code&&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'&scope=openid&nonce=mynonce' -L > temp 2>&1

authzcode=`grep code= temp | awk -F: '{print $1}'| awk -F? '{print $2}' | awk -F= '{print $2}' | awk -F"&" '{print $1}' | cut -d' ' -f1`
authzcode=`echo $authzcode | sed -e 's/ *$//g'`

curl -v -b c -c c -k -X POST -d 'grant_type=authorization_code&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'&code='"${authzcode}" $grant_url -o "curloutput"

if [ -f "curloutput" ]
then
#cat "curloutput"
echo -n "access_token value is: "
cat curloutput |  jq ".access_token" | grep "\"" | cut -d\" -f2
echo -n "refresh_token value is: "
cat curloutput |  jq ".refresh_token" | grep "\"" | cut -d\" -f2
echo -n "token_type value is: "
cat curloutput |  jq ".token_type" | grep "\"" | cut -d\" -f2
echo -n "expires_in value is: "
cat curloutput |  jq ".expires_in" 
echo -n "id_token value is: "
cat curloutput |  jq ".id_token" | grep "\"" | cut -d\" -f2
else
        echo "File doesn't exist"
        exit;

fi

# Print test case detailed output to result_details file
echo "-------------------------------------"$0"------------------------------------------------- "  >> $result_details
echo "-------------temp file output-------------------------------------------------------------" >> $result_details
cat temp >> $result_details
echo "-------------curloutput output-------------------------------------------------------------" >> $result_details
cat curloutput >> $result_details
echo "" >> $result_details
echo "--------------------------------------------------------------------------------------------------"  >> $result_details
echo "" >> $result_details




# Print test case is passed or failed
echo -n $0":" >> $result_summary
if [ -f "curloutput" ]
then
	idtoken=""
	idtoken=`cat curloutput |  jq ".id_token" | grep "\"" | cut -d\" -f2`
	echo $idtoken
	output=""
	
	cd decryptToken/
	sh create-input-file-asymm.sh $idtoken
	sh -vx idtd.sh < input-file-asymm > output
	cd ..
	cat decryptToken/output >> $result_details
	if [  "`cat decryptToken/output | grep -i "Signature verified successfully"`" == "Signature verified successfully" ]
	then
	        echo "PASSED" >>  $result_summary
        else
        	echo "FAILED" >>  $result_summary
        fi
else
	echo "File doesn't exist"
	echo "FAILED" >>  $result_summary
	exit;
fi







#Remove all temporary files used by this script
rm temp
rm curloutput
#rm decryptToken/output
rm decryptToken/input-file-asymm
rm c


