#!/bin/sh
#Input Parameter File Name.

. ./config.txt

#Removing any existing File

if [ -f "curloutput" ]
then
rm curloutput
fi

if [ -f "$json_outputfile" ]
then
rm $json_outputfile
fi


curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

curl -v -b c -c c -k "$authcodeurl"'?response_type=token+id_token&&client_id='"$client_id"'&client_secret='"$client_secret"'&redirect_uri='"$redirect_uri"'&scope=openid&nonce=mynonce' -L -D "curloutput"

# Extract access_token from the curl output
token_access=`grep "access_token=" "curloutput" |  awk -F'access_token=' '{print $2}' | awk -F'&' '{print $1}'`
echo "access token value is:"$token_access
echo "Access Token value is : $token_access " >> $result_details
echo "" >> $result_details
# Extract id_token from the curl output
idtoken=`grep "id_token=" "curloutput" |  awk -F'id_token=' '{print $2}' | awk -F'&' '{print $1}'`
echo "ID Token value is:"$idtoken
echo "ID Token value is : $idtoken " >> $result_details
echo "" >> $result_details
#print other details as part of Access token. Store all values
expires_in=`grep "expires_in=" "curloutput" |  awk -F'expires_in=' '{print $2}' | awk -F'&' '{print $1}'`
echo "expires_in value is : "$expires_in
echo "expires_in value is : $expires_in " >> $result_details
echo "" >> $result_details
token_type=`grep "token_type=" "curloutput" |  awk -F'token_type=' '{print $2}' | awk -F'&' '{print $1}'`
echo "token type value is : "$token_type
echo "token_type value is : $token_type " >> $result_details
echo "" >> $result_details
echo "-------------------------------------------------------------------------------------------------------"  >> $result_details
# Print test case is passed or failed
echo -n $0":" >> $result_summary
if [ "$token_access" != "" ] && [ "$idtoken" != "" ] && [ "$token_type" != "" ] && [ "$expires_in" != "" ]
then
	output=""
	cd decryptToken/
	sh create-input-file-asymm.sh $idtoken
	sh -vx idtd.sh < input-file-asymm > output
	cd ..
	cat decryptToken/output >> $result_details
	issuer=`cat decryptToken/output | grep iss |  jq ".iss" | awk -F'"' '{print $2}'`
        sub=`cat decryptToken/output | grep iss |  jq ".sub" | awk -F'"' '{print $2}'`
        aud=`cat decryptToken/output | grep iss |  jq ".aud" | awk -F'"' '{print $2}'`
        exp=`cat decryptToken/output | grep iss |  jq ".exp" `
        iat=`cat decryptToken/output | grep iss |  jq ".iat" `
        nonce=`cat decryptToken/output | grep iss |  jq ".nonce" | awk -F'"' '{print $2}'`
        echo "Issuer": $issuer >> $result_details
        echo "Subject": $sub >> $result_details
        echo "Audience": $aud >> $result_details
        echo "Expiry": $exp >> $result_details
        echo "IssuedAt": $iat >> $result_details
        echo "nonce": $nonce >> $result_details
        if [  "`cat decryptToken/output | grep -i "Signature verified successfully"`" == "Signature verified successfully" ]
        then
                if [ "$nonce" == "mynonce" ] && [ "$issuer" != "" ] && [ "$sub" != "" ] && [ "$aud" != "" ] && [ "$exp" != "" ] && [ "$iat" != "" ]
                then
                        echo "PASSED" >>  $result_summary
                else
                        echo "FAILED" >>  $result_summary
                fi
	else
		echo "FAILED" >>  $result_summary
        fi
else
	echo "FAILED" >>  $result_summary
fi


#Remove all temporary files used by this script
rm curloutput
#rm decryptToken/output
rm decryptToken/input-file-asymm
rm c


