#!/bin/sh
#Input Parameter File Name.

. ./config.txt

testcase=$0

# Login using credentials
curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Validate token with tokeninfo endpoint " >> $result_details
echo "" >> $result_details
echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details
echo "" >> $result_details

# Request for Access Token
curl -v -b c -c c -k "$authcodeurl"'/?response_type=token&client_id='"$client_id"'&client_secret='"$client_secret"'&resourceServer=Demo_Resource_server&redirect_uri='"$redirect_uri"'&scope=scopeRSEncrypt+scopeRSEncryptClaims' -L -D "curl_outputfile"

# Extract access_token from the curl output
token_access=`grep "access_token=" "curl_outputfile" |  awk -F'&' '{print $2}' | awk -F"=" '{print $2}' | sed -e 's/ *$//g'`
echo "access token value is:"$token_access
echo "" >> $result_details

#print other details as part of Access token. Store all values
expires_in=`grep "expires_in" "curl_outputfile" |  awk -F'#' '{print $2}' | awk -F"&" '{print $3}'|awk -F"=" '{print $2}'`
echo "expires_in value is : $expires_in " >> $result_details
echo "" >> $result_details

token_type=`grep "token_type" "curl_outputfile" |  awk -F'#' '{print $2}' | awk -F"=" '{print $2}'|awk -F"&" '{print $1}'`
echo "token_type value is : $token_type " >> $result_details
echo "" >> $result_details


echo "-------------------------------------------------------------------------------------------------------"  >> $result_details


# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ -f "curl_outputfile" ]
then
	cd decryptToken/
	sh create-input-file_only_signed.sh $token_access
	sh -vx idtd.sh < input-file > output
	cd ..
	cat decryptToken/output >> $result_details
        output=`cat decryptToken/output | grep -i "Signature verified successfully" | awk -F":" '{print $2}'`
	if [ "$output" == "Signature verified successfully" ]
	then
		echo "PASSED" >> $result_summary
	else
		echo "FAILED" >> $result_summary
	fi

else	
	echo "File doesn't exist"
	echo "FAILED" >> $result_summary

fi

#Remove all temporary files used by this script
rm curl_outputfile
rm c tokeninfo.txt
