#!/bin/sh
#Input Parameter File Name.

. ./config.txt

testcase=$0
count=0 #Number of Client register
sampleClientName="OauthDemoClient"

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Register Client for OAuth samples " >> $result_details
echo "username is: $username " >> $result_details
echo "password is: $password " >> $result_details
echo "Scope is: $scope_full " >> $result_details
echo "" >> $result_details

# Login using credentials
curl -v -b c -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

#List the clients registered by this user
curl -v -b c -c c -k $client_url -o output_list

#register Clients with asymmetric algorithm configured for idtoken along with all flows enabled and token types enabled
echo "register Clients with all grants configured for Oauth for all flows enabled " >> $result_details
echo "" >> $result_details

#client_name=`cat output_list | jq "[.[].client_name]" `
client_id=`cat output_list | jq "[.[].client_id]" `
get_name=`cat output_list | jq "[.[].client_name]" | cut -d\" -f2 | grep -i "$sampleClientName" `
echo $get_name

if [ -z "$get_name" ]
then
	echo "Client doesn't exist. Create it." >> $result_details
	curl -v -b c -c c -k -H "Content-Type: application/json" -d '{"application_type":"web","redirect_uris":["https://client.example.org/callback","https://client.example.org/callback2","https://164.99.86.160/bajesh/oauth.php","https://developers.google.com/oauthplayground"],"frontchannel_logout_uri":"https://gmail.logout.com","frontchannel_logout_session_required":true,"post_logout_redirect_uris":["https://client.example.org/callback","https://client2.example.org/callback2"],"subject_type":"pairwise","token_endpoint_auth_method":"client_secret_basic","id_token_encrypted_response_alg":"RSA1_5","id_token_encrypted_response_enc":"A128CBC-HS256","id_token_signed_response_alg":"RS256","contacts":["ve7jtb@example.org","mary@example.org"],"grant_types":["authorization_code","implicit","refresh_token","password","client_credentials"],"response_types":["code","id_token","token"],"client_name":"'$sampleClientName'","jwks_uri":"http://164.99.86.160/anup/client_pubkey.txt", "alwaysIssueNewRefreshToken":true, "accessTokenTTL": 1, "authzCodeTTL": 1, "refreshTokenTTL":3}' "$client_url" -o client_data
else
	echo "Client already exists. Not required to add" >> $result_details  
fi

#Get client ID and Client Secret from client json output
client_id=`cat client_data | jq ".client_id" | cut -d\" -f2`
echo "$client_name's client_id is: $client_id" >> $result_details
client_secret=`cat client_data | jq ".client_secret" | cut -d\" -f2`
echo "$client_name's client_secret is: $client_secret" >> $result_details

#Copy this to config.txt file
if [ `grep -i "client_id" ../config.txt` != "" ]
then

        sed -i '/client_id/c\client_id="'$client_id'"' ../config.txt
        sed -i '/client_secret/c\client_secret="'$client_secret'"' ../config.txt
else
        echo "" >> ../config.txt
         "#client enabled with all parameter" >> ../config.txt
        echo 'client_id="'$client_id'"' >> ../config.txt
        echo 'client_secret="'$client_secret'"' >> ../config.txt
fi

echo "" >> $result_details

#Reload the client list - Output_list
curl -v -b c -c c -k $client_url -o output_list


name_client=`cat output_list | jq "[.[].client_name]" | cut -d\" -f2 | grep -i "$sampleClientName"`
echo "$name_client " >> $result_details

echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

echo "param value is: $client_name" 

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$name_client" == "$sampleClientName" ];
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi

#Remove all temporary files used by this script
rm output_list c client_data
