#!/bin/sh
#Load Configuration Data
. ./config.txt

#Get test case name
testcase=$0

#Variable declaration
count=0
scope1="DemoScope1"
scope2="DemoScope2"
resource="Demo_Resource_server" #will use it as No Encrypt resource server
resource_server_delete="$resource_server_url""/"$resource
custom_resource_server="$resource_server_url""/"$resource/scopes/

#Delete any existing
curl -v -k -X POST -d 'grant_type=password&client_id='"$client_id"'&client_secret='"$client_secret"'&username='"$scope_username"'&password='"$scope_password"'&scope='"$scope_full" "$grant_url"  -o curloutput

access_token=`cat curloutput | jq ".access_token" | cut -d\" -f2 | sed -e 's/ *$//g'`

curl -k -H "Content-Type: application/json" -H 'Authorization: Bearer '"$access_token" -X DELETE "$resource_server_delete"

#Delete Resource Server if Exist
#curl -v -b c -k -X DELETE "$resource_server_url"'/'"$resource" -o $curl_outputfile

#Get the DN value for profile and email
profile=`/usr/bin/ldapsearch -H ldaps://$AC_IP:636 -D cn=$AC_username,o=Novell -w$AC_password -b cn=map,cn=nids,ou=accessManagerContainer,o=novell nidsDisplayName=Profile dn | grep dn | awk -F"dn:" '{print $2}'`

dn_profile=`echo $profile | sed -e 's/ *$//g'`

email=`/usr/bin/ldapsearch -H ldaps://$AC_IP:636 -D cn=$AC_username,o=Novell -w$AC_password -b cn=map,cn=nids,ou=accessManagerContainer,o=novell nidsDisplayName=email dn | grep dn | awk -F"dn:" '{print $2}' | sed -e 's/ *$//g'`

dn_email=`echo $email | sed -e 's/ *$//g'`


# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Pre-Requisite RS for Encryption validation - RSEncrypt" >> $result_details
echo "username is: $username " >> $result_details
echo "password is: $password " >> $result_details
echo "Scope is: $scope_full " >> $result_details
echo "" >> $result_details

#Login using credentials
curl -v -c c -b c -k -X POST -d 'option=credential&Ecom_User_ID='"$scope_username"'&Ecom_Password='"$scope_password" "$loginurl" -L

#Create a resource server
#curl -v -b c -k -H "Content-Type: application/json" -X POST -d '{"name":"'$resource'","cryptoKeys":{"jwksUri": "http://164.99.86.160/anup/client_pubkey.txt", "jwtaccessTokenEncryptionAlgo":{ "encryptionAlg":"RSA1_5","encryptionEnc":"A128CBC-HS256"}}}'  $resource_server_url -o $curl_outputfile

curl -v -b c -k -H "Content-Type: application/json" -X POST -d '{"name":"'$resource'","disableJWTAccessTokenEncryption":true}
}'  $resource_server_url -o $curl_outputfile

resource_name=`cat $curl_outputfile |  jq ".name" | cut -d\" -f2`

if [ "$resource_name" == "$resource" ]
then

#Get the Access token
curl -v -k -X POST -d 'grant_type=password&client_id='"$client_id"'&client_secret='"$client_secret"'&username='"$scope_username"'&password='"$scope_password"'&scope='"$scope_full" "$grant_url"  -o curloutput

access_token=`cat curloutput | jq ".access_token" | cut -d\" -f2 | sed -e 's/ *$//g'`
echo "Access token is: $access_token" >> $result_details
echo "" >> $result_details

	if [ "$access_token" != "null" ]
	then
	#List scope and find out scope name
	curl -k -H "Content-Type: application/json" -H 'Authorization: Bearer '"$access_token" $custom_resource_server  -o scope_list
	scopes=`cat scope_list | jq "[.scopes]" | cut -d\" -f2`
	echo "Scopes name is : $scopes" >> $result_details

	#Register Scope available - Scope 1 and Scope 2
	curl -k -H "Content-Type: application/json" -H 'Authorization: Bearer '"$access_token"  -d '{"scope":"'$scope1'","claims": ["read", "write"], "scope_description":"Scope1 with RS44 pre-req", "userPermissionRequired":false,"includeAllClaimsInJWT":true,"adminApprovalRequired":false, "isGroupOfUserAttributes":false}' $custom_resource_server > out_list

	scope_name1=`cat out_list | jq ".scope" | cut -d\" -f2`
	echo "Register scope is: " >> $result_details
	cat out_list >> $result_details

	curl -k -H "Content-Type: application/json" -H 'Authorization: Bearer '"$access_token"  -d '{"scope":"'$scope2'", "attribute_set": {"name": "Profile", "dn" :"'$dn_profile'"},"scope_description":"Scope2 with RS44 pre-req profile", "isGroupOfUserAttributes":true, "userPermissionRequired":false,"includeAllClaimsInJWT":true,"adminApprovalRequired":false}' $custom_resource_server > out_list

	echo "Register scope is: " >> $result_details
	cat out_list >> $result_details
	echo "" >> $result_details

	scope_name2=`cat out_list | jq ".scope" | cut -d\" -f2`
	echo "Scope Name is: $scope_name2" >> $result_details

	else
	echo "Access token is null" >> $result_details
	echo "FAILED" >>  $result_summary
	fi

else
	echo "Unable to create RS" >> $result_details
	echo "FAILED" >>  $result_summary
fi


echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$scope_name1" == "$scope1" ] && [ "$scope_name2" == "$scope2" ]
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi

#Remove all temporary files used by this script
rm curloutput $curl_outputfile
rm scope_list c
rm out_list
