#!/bin/sh
#Input Parameter File Name.

. ./config.txt

testcase=$0
count=0 #Number of Client register

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "Test for Listing All clients for a particular developer User and delete them " >> $result_details
echo "username is: $username " >> $result_details
echo "password is: $password " >> $result_details
echo "Scope is: $scope_full " >> $result_details
echo "" >> $result_details

# Login using credentials
curl -v -c c -k -X POST -d 'option=credential&Ecom_User_ID='"$username"'&Ecom_Password='"$password" "$loginurl" -L

#List the clients registered by this user
curl -v -b c  -k $client_url -o output_list

client_id=`cat output_list | jq "[.[].client_id]" | cut -d\" -f2`

for i in ${client_id[@]}; do
count=$[$count + 1]
echo "Total Number of client registered is: $count" >> $result_details

#Delete client
curl -v -b c -k -H "Content-Type: application/json" -X DELETE "$client_url"/"""$i"
done

echo "-------------------------------------------------------------------------------------------------------"  >> $result_details
#List the clients again 
curl -v -b c -k $client_url -o output_list

error_description=`cat output_list | jq ".error_description" | cut -d\" -f2`
error_message=`cat output_list | jq ".error" | cut -d\" -f2`

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$error_description" == "Not registered any client" ] && [ "$error_message" == "Info" ] 
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi

#Remove all temporary files used by this script
rm curloutput output_list c
