#!/bin/sh
echo "###########Load Local Configuration###########"

. ./config.txt
testcase=$0

curl -v -k -X POST -d 'grant_type=password&client_id='"$client_id"'&client_secret='"$client_secret"'&username='"$username"'&password='"$password" "$ro_url" -o "curloutput"

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "" >> $result_details
echo " RO with madatory parameter " >> $result_details
echo "" >> $result_details
echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details
echo "" >> $result_details
echo -n " server response is:" >> $result_details
cat curloutput >> $result_details
echo "" >> $result_details

#Get access token value
token_access=`cat curloutput | jq ".access_token" | cut -d\" -f2`
echo " access token value is : $token_access " >> $result_details
echo "" >> $result_details

token_type=`cat curloutput | jq ".token_type" | cut -d\" -f2`
echo "token type is : $token_type " >> $result_details
echo "" >> $result_details

expires_in=`cat curloutput | jq ".expires_in" | cut -d\" -f2`
echo "expiry time is : $expires_in " >> $result_details
echo "" >> $result_details

refresh_token=`cat curloutput | jq ".refresh_token" | cut -d\" -f2`
echo "refresh token is : $refresh_token " >> $result_details

echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$token_access" != "" ] 
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi


#Remove all temporary files used by this script
rm curloutput

