#!/bin/sh
echo "###########Load Local Configuration###########"

. ./config.txt
testcase=$0

curl -v -k -X POST -d 'grant_type=password&client_id='"$client_id"'&client_secret='"$client_secret"'&resourceServer=Demo_Resource_server&username='"$username"'&password='"$password" "$ro_url" -o "curl_outputfile"

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "" >> $result_details
echo " RO jwt token with tokeninfo endpoint " >> $result_details
echo "" >> $result_details
echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details
echo "" >> $result_details
echo -n " server response is:" >> $result_details
cat curl_outputfile >> $result_details
echo "" >> $result_details

#Get access token value
token_access=`cat curl_outputfile | jq ".access_token" | cut -d\" -f2 | sed -e 's/ *$//g'`
echo " access token value is : $token_access " >> $result_details
echo "" >> $result_details

token_type=`cat curl_outputfile | jq ".token_type" | cut -d\" -f2`
echo "token type is : $token_type " >> $result_details
echo "" >> $result_details

expires_in=`cat curl_outputfile | jq ".expires_in" | cut -d\" -f2`
echo "expiry time is : $expires_in " >> $result_details
echo "" >> $result_details

echo "-------------------------------------------------------------------------------------------------------"  >> $result_details


# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ -f "curl_outputfile" ]
then
        cd decryptToken/
        sh create-input-file_only_signed.sh $token_access
        sh -vx idtd.sh < input-file > output
        cd ..
        cat decryptToken/output >> $result_details
	output=`cat decryptToken/output | grep -i "Signature verified successfully" | awk -F":" '{print $2}'`
        if [ "$output" == "Signature verified successfully" ]
        then
                echo "PASSED" >> $result_summary
        else
                echo "FAILED" >> $result_summary
        fi

else
        echo "File doesn't exist"
        echo "FAILED" >> $result_summary

fi


#Remove all temporary files used by this script
rm curl_outputfile
rm json_outputfile
rm tokeninfo.txt
