#!/bin/sh
echo "###########Load Local Configuration###########"

. ./config.txt
testcase=$0
device_id="RoFlow_sles12Test"

curl -v -k -X POST -d 'grant_type=password&client_id='"$client_id"'&client_secret='"$client_secret"'&device_id='"$device_id"'&username='"$username"'&password='"$password" "$ro_url" -o "curl_outputfile"

# Print test case detailed output to result_details file
echo "-------------------------------------$testcase:-------------------------------------------------- "  >> $result_details
echo "" >> $result_details
echo " Revoke all token using device ID at global level - Refresh token revocation with RO flow" >> $result_details
echo "" >> $result_details
echo "client id is: $client_id " >> $result_details
echo "client secret is: $client_secret" >> $result_details
echo "redirect uri used in code is: $redirect_uri" >> $result_details
echo "" >> $result_details
echo -n " server response is:" >> $result_details
cat curl_outputfile >> $result_details
echo "" >> $result_details

#Get access token value
token_access=`cat curl_outputfile | jq ".access_token" | cut -d\" -f2`
token_type=`cat curl_outputfile | jq ".token_type" | cut -d\" -f2`
expires_in=`cat curl_outputfile | jq ".expires_in" | cut -d\" -f2`
refresh_token=`cat curl_outputfile | jq ".refresh_token" | cut -d\" -f2`

#Revoke token
curl -v -k -H "Content-Type: application/x-www-form-urlencoded" -X POST -d 'userstore_name='"$userstore"'&user_dn='"$user_dn" "$revokeEP""/"$device_id

#send revoked refresh token to  get access token
curl -v -k -X POST -d 'grant_type=refresh_token&client_id='"$client_id"'&client_secret='"$client_secret"'&refresh_token='"$refresh_token" "$grant_url" -o token_output

cat token_output >> $result_details

error=`cat token_output | jq ".error" | cut -d\" -f2`
error_des=`cat token_output | jq ".error_description" | cut -d\" -f2`

echo "-------------------------------------------------------------------------------------------------------"  >> $result_details

# Print test case is passed or failed
echo -n $testcase":" >> $result_summary
if [ "$token_access" != "" ] && [ "$error" == "invalid_grant" ] && [ "$error_des" == "invalid_grant: Refresh token has been revoked." ]
then
        echo "PASSED" >>  $result_summary
else
        echo "FAILED" >>  $result_summary
fi


#Remove all temporary files used by this script
rm curl_outputfile
rm json_outputfile
rm token_output
