/*
 * Copyright (c) 2017 Microfocus Corporation. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.microfocus.android.sampleapp.shyanimals;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.Toast;

import com.microfocus.android.mobile.sdk.library.ServiceContextFactory;
import com.microfocus.android.mobile.sdk.library.util.DateTimeUtil;
import com.microfocus.android.mobile.sdk.library.IdentityProvider;

import java.util.List;

/**
 * Provides "Toast" hints that prompt the sample application Shy Animals user to
 * take actions.
 * <p>
 * This class is not essential to understanding how an implementor might
 * integrate with the Microfocus Android Mobile SDK.
 */
public class HintsTask extends AsyncTask<Void, Void, String> {
    private static final String TAG = "HintsTask";

    private static final String ALL_HAPPY = "All of the animals are happy because they all know who you are.";
    private static final String SOME_SHY = "Some of the animals are being shy because they do not know who you are. Use the application drop down menu to authenticate.";
    private static final String NO_IDENTITY_PROVIDERS = "Define an Identity Provider so the shy animals might get to know you.";

    private static final long HINTS_TASK_PERIOD = 2 * DateTimeUtil.MINUTE_IN_MILLIS;
    private static long lLastHintsTaskStartTime;
    private static HintsTask lastHintTask;

    private Context context;

    private HintsTask (Context context) {
        this.context = context;
    }

    @Override
    protected void onPreExecute() {
    }

    @Override
    protected String doInBackground(Void... voids) {
        try {
            String message = NO_IDENTITY_PROVIDERS;
            IdentityProvider identityProvider = ServiceContextFactory.getInstance().getIdentityProvider();
            if (null != identityProvider) {
                message = ALL_HAPPY;
                Settings settings = new Settings(context);
                IdentityProviderStatus status = new IdentityProviderStatus(context, identityProvider,
                                               settings.getAccessTokenRefreshBeforeExpirationBy());
                if (isCancelled()) {
                    return null;
                }
                if (!status.isAllGood()) {
                    message = SOME_SHY;
                }
            }
            return message;
        }
        catch (Throwable t)
        {
            Log.d(TAG, "Exception examining identity providers.", t);
        }
        return null;
    }

    @Override
    protected void onPostExecute(String message) {
        if (null != message) {
            Toast.makeText(context, message, Toast.LENGTH_LONG).show();
        }
    }

    static synchronized void doHintIfTime(Context context)
    {
        if ((System.currentTimeMillis() - lLastHintsTaskStartTime) > HINTS_TASK_PERIOD)
        {
            lLastHintsTaskStartTime = System.currentTimeMillis();
            if ((null != lastHintTask) && (Status.FINISHED != lastHintTask.getStatus()))
            {
                lastHintTask.cancel(true);
            }
            lastHintTask = new HintsTask(context);
            lastHintTask.execute();
        }
    }
}