/*
 * Copyright (c) 2017 Microfocus Corporation. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.microfocus.android.sampleapp.shyanimals;

import android.content.Context;
import android.content.SharedPreferences;

import com.microfocus.android.mobile.sdk.library.ServiceContext;

/**
 * Settings associated with the sample application Shy Animals.
 */
public class Settings {

    private static final String PREFERENCES_SETTINGS_NAME = "Settings";

    static final String PREFERENCE_ACCESS_TOKEN_REFRESH_BEFORE_EXPIRATION_BY = "accessTokenRefreshBeforeExpirationBy";

    private long lAccessTokenRefreshBeforeExpirationBy;

    private Context context;

    private boolean dirty = false;

    public Settings(Context context)
    {
        this.context = context;
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCES_SETTINGS_NAME, Context.MODE_PRIVATE);
        lAccessTokenRefreshBeforeExpirationBy = prefs.getLong(PREFERENCE_ACCESS_TOKEN_REFRESH_BEFORE_EXPIRATION_BY, ServiceContext.ACCESS_TOKEN_REFRESH_BEFORE_EXPIRATION_BY_DEFAULT);
     }

    public void setAccessTokenRefreshBeforeExpirationBy(long l)
    {
        if (lAccessTokenRefreshBeforeExpirationBy != l) {
            lAccessTokenRefreshBeforeExpirationBy = l;
            setDirty();
        }
    }

    public long getAccessTokenRefreshBeforeExpirationBy()
    {
        return lAccessTokenRefreshBeforeExpirationBy;
    }

    public void apply()
    {
        if (isDirty()) {
            SharedPreferences prefs = context.getSharedPreferences(PREFERENCES_SETTINGS_NAME, Context.MODE_PRIVATE);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putLong(PREFERENCE_ACCESS_TOKEN_REFRESH_BEFORE_EXPIRATION_BY, getAccessTokenRefreshBeforeExpirationBy());
            editor.apply();
        }
    }

    private void setDirty()
    {
        dirty = true;
    }

    private boolean isDirty()
    {
        return dirty;
    }
}
