package com.microfocus.android.sampleapp.shyanimals;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.microfocus.android.mobile.sdk.library.ServiceContextFactory;
import com.microfocus.android.mobile.sdk.library.UnAuthenticatorReport;
import com.microfocus.android.mobile.sdk.library.util.DateTimeUtil;

import java.text.MessageFormat;
import java.util.Collection;

/**
 * Created by SJensen on 4/10/2017.
 */

public class UnAuthenticateReportActivity  extends AppCompatActivity {
    final private String TAG = "UnA12ReportActivity";
    final public static String REPORT_ACTIVITY_JSON = "reportActivityJson";

    private static final String SUCCESSFUL_LOGOUT = "Successful Un-Authentication";
    private static final String FAILED_LOGOUT = "Failed Un-Authentication";
    private static final String PARTIAL_LOGOUT = "Partial Un-Authentication";

    private static final String EXISTS_NO = "Exists: no";
    private static final String EXISTS_CHARACTERS = "Exists: {0} characters";
    private static final String EXPIRED_AGO = "Expired {0} ago";
    private static final String EXPIRES_IN = "Expires in {0}";
    private static final String DISALLOWED = "Disallowed";

    private static final String INITIATED = "Initiated: {0}";
    private static final String REVOCATION_INITIATED = "Token Revocation Initiated: {0}";
    private static final String REVOCATION_DISALLOWED = "Token Revocation: Disallowed";
    private static final String STARTED = "Started Loading Logout URL: {0}";
    private static final String FINISHED = "Finished Loading Logout URL: {0}";
    private static final String ABORTED = "Aborted Loading Logout URL: {0}";
    private static final String FAILED = "Failed Loading Logout URL: {0}";

    private static final String UNAUTHENTICATION_STARTED = "Is UnAuthentication Started: {0}";
    private static final String UNAUTHENTICATION_STOPPED = "Is UnAuthentication Complete: {0}";
    private static final String UNAUTHENTICATION_TIMEDOUT = "Is UnAuthentication Timed Out: {0}";
    private static final String DURATION_SINCE_CREATION = "UnAuthenticator Created {0} ago";
    private static final String DURATION_SINCE_STARTED = "UnAuthenticator Started {0} ago";
    private static final String DURATION_AUTHENTICATION = "UnAuthenticator Completed in: {0}";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_unauthenticate_report);
        String strReportJson = getIntent().getStringExtra(REPORT_ACTIVITY_JSON);
        if (strReportJson == null) {
            return;
        }
        UnAuthenticatorReport report = ServiceContextFactory.getInstance().fromJsonUnAuthenticatorReport(strReportJson);
        LinearLayout layoutParent = (LinearLayout) findViewById(R.id.reportTopLevelLayout);

        TextView overallStatusLabel = (TextView) findViewById(R.id.statusUnAuthenticationLabel);
        if (report.isSuccessfulUnAuthentication())
        {
            overallStatusLabel.setText(SUCCESSFUL_LOGOUT);
        }
        else if (report.isFailedUnAuthentication())
        {
            overallStatusLabel.setText(FAILED_LOGOUT);
        }
        if (report.isPartialUnAuthentication())
        {
            overallStatusLabel.setText(PARTIAL_LOGOUT);
        }

        String strIdentityProviderHost = "Unknown Identity Provider Host";
        String strIdentityProviderClientId = "Unknown Identity Provider Client Id";
        if (null != report.getIdentityProvider()) {
            strIdentityProviderHost = report.getIdentityProvider().getHost();
            strIdentityProviderClientId = report.getIdentityProvider().getClientId();
        }
        ((TextView) findViewById(R.id.unAuthIdentityProviderHost)).setText(strIdentityProviderHost);
        ((TextView) findViewById(R.id.unAuthidentityProviderClientId)).setText(strIdentityProviderClientId);

        if (0 == addExceptions(layoutParent,
                (TextView) findViewById(R.id.unauthenticatorErrors),
                report.getAuthenticatorExceptions())) {
            layoutParent.removeView(findViewById(R.id.unauthenticatorErrors));
        }

        TextView viewAccessToken = (TextView) findViewById(R.id.unAuthAccessTokenExists);
        TextView viewAccessTokenExpiration = (TextView) findViewById(R.id.unAuthAccessTokenExpiration);
        String strAccessToken = report.getAccessToken();
        if (null == strAccessToken) {
            viewAccessToken.setText(EXISTS_NO);
            layoutParent.removeView(viewAccessTokenExpiration);
        } else {
            viewAccessToken.setText(MessageFormat.format(EXISTS_CHARACTERS, "" + strAccessToken.length()));
            long lExpiresIn = (report.getAccessTokenExpirationTime() - System.currentTimeMillis());
            if (lExpiresIn < 0) {
                viewAccessTokenExpiration.setText(MessageFormat.format(EXPIRED_AGO, DateTimeUtil.getDuration(-lExpiresIn)));
            } else {
                viewAccessTokenExpiration.setText(MessageFormat.format(EXPIRES_IN, DateTimeUtil.getDuration(lExpiresIn)));
            }
        }
        TextView viewRefreshToken = (TextView) findViewById(R.id.unAuthRefreshTokenExists);
        String strRefreshToken = report.getRefreshToken();
        if (null == strRefreshToken) {
            viewRefreshToken.setText(EXISTS_NO);
        }
        else
        {
            viewRefreshToken.setText(MessageFormat.format(EXISTS_CHARACTERS, "" + strRefreshToken.length()));
        }

        TextView viewInitiated = (TextView)findViewById(R.id.unAuthRefreshTokenRevocationInitiated);
        if (report.tokenRevocationDisallowed() &&
            !report.tokenRevocationInitiated())
        {
            viewInitiated.setText(REVOCATION_DISALLOWED);
        }
        else
        {
            viewInitiated.setText(MessageFormat.format(REVOCATION_INITIATED, report.tokenRevocationInitiated()));
        }

        if (0 == addExceptions(layoutParent,
                (TextView) findViewById(R.id.unAuthRefreshTokenRevokedErrors),
                report.getTokenRevocationExceptions())) {
            layoutParent.removeView(findViewById(R.id.unAuthRefreshTokenRevokedErrors));
        }

        viewInitiated = (TextView)findViewById(R.id.unAuthBrowserLogoutInitiated);
        if (report.browserBasedLogoutDisallowed() &&
            !report.browserBasedLogoutInitiated())
        {
            viewInitiated.setText(DISALLOWED);
        }
        else
        {
            viewInitiated.setText(MessageFormat.format(INITIATED, report.browserBasedLogoutInitiated()));
        }

        if (!report.browserBasedLogoutDisallowed())
        {
            TextView viewStarted = (TextView) findViewById(R.id.unAuthBrowserLogoutStarted);
            viewStarted.setText(MessageFormat.format(STARTED, report.browserBasedLogoutStarted()));

            TextView viewFinished = (TextView) findViewById(R.id.unAuthBrowserLogoutFinished);
            viewFinished.setText(MessageFormat.format(FINISHED, report.browserBasedLogoutFinished()));

            TextView viewAborted = (TextView) findViewById(R.id.unAuthBrowserLogoutAborted);
            viewAborted.setText(MessageFormat.format(ABORTED, report.browserBasedLogoutAborted()));

            TextView viewFailed = (TextView) findViewById(R.id.unAuthBrowserLogoutFailed);
            viewFailed.setText(MessageFormat.format(FAILED, report.browserBasedLogoutFailed()));

            if (0 == addExceptions(layoutParent,
                    (TextView) findViewById(R.id.unAuthBrowserLogoutErrors),
                    report.getBrowserBasedLogoutExceptions())) {
                layoutParent.removeView(findViewById(R.id.unAuthBrowserLogoutErrors));
            }
        }
        else
        {
            layoutParent.removeView(findViewById(R.id.unAuthBrowserLogoutStarted));
            layoutParent.removeView(findViewById(R.id.unAuthBrowserLogoutFinished));
            layoutParent.removeView(findViewById(R.id.unAuthBrowserLogoutAborted));
            layoutParent.removeView(findViewById(R.id.unAuthBrowserLogoutFailed));
            layoutParent.removeView(findViewById(R.id.unAuthBrowserLogoutErrors));
        }

        TextView viewAuthenticationStarted = (TextView) findViewById(R.id.isUnAuthenticationStarted);
        viewAuthenticationStarted.setText(MessageFormat.format(UNAUTHENTICATION_STARTED, report.isStarted()));

        TextView viewAuthenticationStopped = (TextView) findViewById(R.id.isUnAuthenticationComplete);
        viewAuthenticationStopped.setText(MessageFormat.format(UNAUTHENTICATION_STOPPED, report.isStopped()));

        TextView viewTimedOut = (TextView)findViewById(R.id.isUnAuthenticationTimedOut);
        viewTimedOut.setText(MessageFormat.format(UNAUTHENTICATION_TIMEDOUT, report.logoutTimedOut()));

        TextView viewDurationSinceCreation = (TextView) findViewById(R.id.durationUnAuthSinceCreation);
        viewDurationSinceCreation.setText(MessageFormat.format(DURATION_SINCE_CREATION, DateTimeUtil.getDuration(report.getDurationSinceCreation())));

        TextView viewDurationAuthentication = (TextView) findViewById(R.id.durationUnAuthentication);
        TextView viewDurationSinceStarted = (TextView) findViewById(R.id.durationUnAuthSinceStarted);
        if (report.isStopped()) {
            viewDurationAuthentication.setText(MessageFormat.format(DURATION_AUTHENTICATION, DateTimeUtil.getDuration(report.getDuration())));
            layoutParent.removeView(viewDurationSinceStarted);
        } else if (report.isStarted()) {

            viewDurationSinceStarted.setText(MessageFormat.format(DURATION_SINCE_STARTED, DateTimeUtil.getDuration(report.getDuration())));
            layoutParent.removeView(viewDurationAuthentication);
        }
    }

    private int addExceptions(LinearLayout layoutParent, TextView insertView, Collection<Exception> exceptions) {
        int iCount = 0;
        if ((null != exceptions) && (0 != exceptions.size())) {
            int iAddIndex = layoutParent.indexOfChild(insertView);
            for (Exception current : exceptions) {
                TextView childView = new TextView(this);
                childView.setId(View.generateViewId());
                childView.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT));
                childView.setText(" - " + current.getClass().getSimpleName() + ": " + current.getMessage());
                childView.setPadding(childView.getPaddingLeft() + 15, childView.getPaddingTop(), childView.getPaddingRight(), childView.getPaddingBottom());
                layoutParent.addView(childView, iAddIndex + 1);
                iCount++;
            }
        }
        return iCount;
    }
}
