// deleteServiceProvider.js is an example of using the AMService APIs to delete a trusted service provider
// Run refreshIdpCluster.js after this for your changes to take effect
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4


// ACTION REQUIRED: Replace the serviceProviderId value below with the instanceID of the trusted service provider you want to delete.
//                  See getServiceProviders.js for an example of reading the instanceID of a service provider programatically.
var serviceProviderId = 'TSP_d4f733c6-40dc-495b-b6d6-3f74a54ff4d2';


require('./common').then(function(common) {

	// Sets up options for calling the API
	var options = {
	    host: common.host,
	    port: common.port,
	    path: '/amsvc/v1/idpclusters/' + common.clusterId + '/serviceproviders/' + serviceProviderId,
	    method: 'DELETE',
	    headers: {
	        'Authorization': common.authHeader,
	        'Accept': 'application/json'
	    }
	};

	// Calls the API and logs the result
	common.httpsRequest(options).then(function(response) {
		console.log(common.prettyJson(response.json ? response.json : response));

	}).catch(function(err) {
	    console.log('An error occurred calling the API to delete the trusted service provider:', err);
	});

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});