// getConnectorDefinitions.js is an example of using the AMService APIs to retrieve a list of connector definitions
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4

require('./common').then(function(common) {

	// Sets up options for calling the API
	var options = {
	    host: common.host,
	    port: common.port,
	    path: '/amsvc/v1/connectordefinitions',
	    method: 'GET',
	    headers: {
	        'Authorization': common.authHeader,
	        'Accept': 'application/json'
	    }
	};

	// Calls the API and logs the result
	common.httpsRequest(options).then(function(response) {
		console.log(common.prettyJson(response.json ? response.json : response));

		// Now that we've retrieved the list of connector definitions, the following is an example of how to get
		// the connectorDefinitionId of a connector definition if we know the definition name.
		var name = 'Salesforce';
		if (response.statusCode >= 200 && response.statusCode < 300 && response.json) {
			console.log('\n', name, 'connector defintion has instanceID:', getConnectorDefinitionIdByName(response.json, name));
		}

	}).catch(function(err) {
	    console.log('An error occurred calling the API to list the connector definitions:', err);
	});

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});

// Returns the instanceID of the connector definition that has the given name, or undefined if none match.
function getConnectorDefinitionIdByName(amServiceResponseDoc, name) {
	for (var i = 0; i < amServiceResponseDoc.connectorDefinitionList.connectorDefinition.length; i++) {
  		if (amServiceResponseDoc.connectorDefinitionList.connectorDefinition[i].name === name) {
    		return amServiceResponseDoc.connectorDefinitionList.connectorDefinition[i].instanceID;
  		}
	}
  	return undefined;
}