// modifyServiceProvider.js is a general example of using the AMService APIs to modify a trusted service provider
// Run refreshIdpCluster.js after this for your changes to take effect
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4


// ACTION REQUIRED: Replace the serviceProviderId value below with the instanceID of the trusted service provider that you want to modify.
//                  See getServiceProviders.js for an example of reading the instanceID of a service provider programatically.
var serviceProviderId = 'TSP_ffd3ee4d-c1bb-490b-b3f8-73119f0d878c';


// ACTION REQUIRED: Edit the serviceProvider below to contain your updates. Only those values you want to change need to be included.
//                  Values that can be updated include displayName, isEnabled, and metadata. See updateServiceProviderMetadata.js for a 
//                  more specific way of updating only the metadata.
var serviceProvider = {
    isEnabled: 'FALSE'
};


require('./common').then(function(common) {

    // Sets up options for calling the API
    var options = {
        host: common.host,
        port: common.port,
        path: '/amsvc/v1/idpclusters/' + common.clusterId + '/serviceproviders/' + serviceProviderId,
        method: 'PUT',
        headers: {
            'Authorization': common.authHeader,
            'Accept': 'application/json',
            'Content-Type': 'application/json ; charset=UTF-8'
        }
    };

    // Calls the API and logs the result
    common.httpsRequest(options, JSON.stringify(serviceProvider)).then(function(response) {
        console.log(common.prettyJson(response.json ? response.json : response));

    }).catch(function(err) {
        console.log('An error occurred calling the API to modify the trusted service provider:', err);
    });

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});