// updateServiceProviderMetadata.js is an example of using the AMService APIs to update the metadata of a trusted service provider
// Run refreshIdpCluster.js after this for your changes to take effect
// Written and tested using Node.js v6.10.2 LTS and Access Manager 4.4


// ACTION REQUIRED: Replace the serviceProviderId value below with the instanceID of the trusted service provider that needs updated metadata.
//                  See getServiceProviders.js for an example of reading the instanceID of a service provider programatically.
var serviceProviderId = 'TSP_ffd3ee4d-c1bb-490b-b3f8-73119f0d878c';


// ACTION REQUIRED: Edit the serviceProvider metadata value below to contain the updated metadata. The metadata value may be either a URL where the metadata can be fetched, or the base64-encoded metadata XML.
var serviceProvider = {
    metadata: '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'
};


require('./common').then(function(common) {

    // Sets up options for calling the API
    var options = {
        host: common.host,
        port: common.port,
        path: '/amsvc/v1/idpclusters/' + common.clusterId + '/serviceproviders/' + serviceProviderId + '/metadata',
        method: 'PUT',
        headers: {
            'Authorization': common.authHeader,
            'Accept': 'application/json',
            'Content-Type': 'application/json ; charset=UTF-8'
        }
    };

    // Calls the API and logs the result
    common.httpsRequest(options, JSON.stringify(serviceProvider)).then(function(response) {
        console.log(common.prettyJson(response.json ? response.json : response));
        
    }).catch(function(err) {
        console.log('An error occurred calling the API to update the metadata of the trusted service provider:', err);
    });

}).catch(function(err) {
    console.log('An error occurred when common.js tried to programatically determine the clusterId:', err);
});