(function (window, document) {
    var isAuthenticated = false;
    var TARGET_BLANK = '_blank';
    var TARGET_SELF = '_self';

    var _snippetConfig,
        _contractConfiguration = {},
        _formElement,
        _passwordInputElement,
        _usernameInputElement,
        _submitButtonElement,
        _loginContainerElement;


    /** POLYFILLS **/

    if (typeof Object.assign != 'function') {
        Object.defineProperty(Object, "assign", {
            value: function assign(target, varArgs) {
                'use strict';
                if (target == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }

                var to = Object(target);

                for (var index = 1; index < arguments.length; index++) {
                    var nextSource = arguments[index];

                    if (nextSource != null) {
                        for (var nextKey in nextSource) {
                            if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                                to[nextKey] = nextSource[nextKey];
                            }
                        }
                    }
                }
                return to;
            },
            writable: true,
            configurable: true
        });
    }


    /** HTML TEMPLATES **/

    function buildSSPRLinks() {
        var forgotPasswordUrl = _snippetConfig.forgotPasswordUrl;
        var registerUrl = _snippetConfig.registerUrl;

        if (_contractConfiguration.hasOwnProperty('sspr')) {
            forgotPasswordUrl = forgotPasswordUrl || _contractConfiguration.sspr['forgot-pwd-url'];
            registerUrl = registerUrl || _contractConfiguration.sspr['register-url']
        }

        if (!(forgotPasswordUrl || registerUrl)) {
            return '';
        }

        var html = [];
        if (forgotPasswordUrl) {
            html.push('     <a href="' + forgotPasswordUrl + '" target="' + (_snippetConfig.forgotPasswordLinkNewTab ? TARGET_BLANK : TARGET_SELF) + '">' + _snippetConfig.text.forgotPassword + '</a>');
        }
        if (registerUrl) {
            html.push('		<a href="' + registerUrl + '" target="' + (_snippetConfig.registerLinkNewTab ? TARGET_BLANK : TARGET_SELF) + '">' + _snippetConfig.text.register + '</a>');
        }

        return html.join('\n');
    }

    function buildField(id, label, placeholder, name, type) {
        if (!placeholder) {
            return '           <label for="' + id + '">' + label + '</label>' +
                '	 	    <input id="' + id + '" name="' + name + '" type="' + type + '" required>';
        }

        return '	 	    <input id="' + id + '" name="' + name + '" type="' + type + '" required placeholder="' + label + '">';
    }

    function buildFormContent() {
        var html = '<div class="' + _snippetConfig.classNames.contract + '">' +
            '   <h2>' + _snippetConfig.text.title + '</h2>' +
            '	<form id="' + _snippetConfig.ids.form + '" ' + (_snippetConfig.loginUsingAjax ? '' : 'action="' + getSubmitLoginUrl() + '" ') + 'novalidate method="post">' +
            '       <input type="hidden" name="option" value="credential">';

        if (!_snippetConfig.loginUsingAjax && _snippetConfig.loginRedirectUrl) {
            html += '       <input type="hidden" name="target" value="' + _snippetConfig.loginRedirectUrl + '">';
        }

        return html +
            '		<div class="' + _snippetConfig.classNames.inputContainer + '">' +
            buildField(
                _snippetConfig.ids.usernameInput,
                (_snippetConfig.text.usernameLabel || _contractConfiguration.login['username-label'] || 'Username'),
                _snippetConfig.usernameLabelPlaceholder,
                'Ecom_User_ID',
                'text') +
            '		</div>' +
            '		<div class="' + _snippetConfig.classNames.inputContainer + '">' +
            buildField(
                _snippetConfig.ids.passwordInput,
                (_snippetConfig.text.passwordLabel || _contractConfiguration.login['password-label'] || 'Password'),
                _snippetConfig.passwordLabelPlaceholder,
                'Ecom_Password',
                'password') +
            '		</div>' +
            '	    <div class="' + _snippetConfig.classNames.formActions + '">' +
            '		    <input id="' + _snippetConfig.ids.loginSubmit + '" value="' + _snippetConfig.text.submit + '"  type="submit">' +
            buildSSPRLinks() +
            '       </div>' +
            '	</form>' +
            '</div>';
    }

    function buildSocialLinks(authProviders) {
        var socialProviderHtml = authProviders
            .map(function (authProvider) {
                return '	    <li>' +
                    '	        <a href="' + authProvider.url + '" ' +
                    '               target="' + (_snippetConfig.socialLinksNewTab ? TARGET_BLANK : TARGET_SELF) + '" ' +
                    '               title="' + authProvider.name + '">' +
                    '	            <img src="' + authProvider.icon + '" alt="' + authProvider.name + '">' +
                    '	            <span>' + authProvider.name + '</span>' +
                    '	        </a>' +
                    '	    </li>';
            })
            .join('\n');

        return '<div class="' + _snippetConfig.classNames.contract + '">' +
            '	<h3>' + _snippetConfig.text.socialTitle + '</h3>' +
            '	<ul class="' + _snippetConfig.classNames.authProviderList + '">' +
            socialProviderHtml +
            '	</ul>' +
            '</div>';
    }

    function buildContainer() {
        var el = document.createElement('div');
        el.id = _snippetConfig.ids.loginContainer;
        el.className = _snippetConfig.classNames.loginContainer;
        el.innerHTML = '<div class="' + _snippetConfig.classNames.loadingContainer + '"></div>'

        return el;
    }

    function buildForm() {
        var html = buildFormContent();

        if (_snippetConfig.socialAuthProviders && _snippetConfig.socialAuthProviders.length) {
            html += buildSocialLinks(_snippetConfig.socialAuthProviders);
        }
        else if (_contractConfiguration.social && _contractConfiguration.social.length) {
            html += buildSocialLinks(_contractConfiguration.social);
        }

        return html;
    }

    function showAuthenticatedMessage() {
        var parent = getParentElement();
        parent.innerHTML = '<span>' + _snippetConfig.text.loggedIn + '</span>';
    }

    function handleAuthenticatedUser() {
        if (!_snippetConfig.loginRedirectUrl && !_snippetConfig.apiHost) {
            return showAuthenticatedMessage();
        }

        window.location = _snippetConfig.loginRedirectUrl || joinUrl(_snippetConfig.apiHost, '/nidp/portal');
    }

    /** CONTRACT CONFIGURATION REQUEST **/

    function fetchContractConfiguration(successCallback, failureCallback) {
        var xhr = new XMLHttpRequest();

        xhr.onreadystatechange = function () {
            if (this.readyState === 4) {
                clearLoadingState();

                if (this.status === 200) {
                    successCallback(JSON.parse(this.responseText));
                }
                else {
                    failureCallback();
                }
            }
        };

        setLoadingState();


        xhr.open("GET", joinUrl(_snippetConfig.apiHost, _snippetConfig.apiContractConfigurationPath), true);
        xhr.setRequestHeader('Accept', 'application/json');
        xhr.send();
    }

    function joinUrl(url, relative) {
        url = url.replace(/[\\\/]+$/, '');
        relative = relative.replace(/^[\\\/]+/, '');

        return url + '/' + relative;
    }

    function getParentElement() {
        return isObject(_snippetConfig.parent) ? _snippetConfig.parent : document.getElementById(_snippetConfig.parent);
    }

    function loadForm() {
        _loginContainerElement.insertAdjacentHTML('afterbegin', buildForm());

        initializeFormValidation();
    }

    function onFetchContractConfigurationSuccess(response) {
        _contractConfiguration = response;

        loadForm();
    }

    function onFetchContractConfigurationFailure() {
        var parent = isObject(_snippetConfig.parent) ? _snippetConfig.parent : document.getElementById(_snippetConfig.parent);

        var element = document.createElement('h2');
        element.innerText = _snippetConfig.text.error;

        parent.appendChild(element);
    }


    /** FORM VALIDATION **/

    function onInputChange(event) {
        setInputElementDirty(event.target);
        updateFormState();
    }

    function setInputElementDirty(element) {
        element.classList.add(_snippetConfig.classNames.dirty);
    }

    function setFormDirty() {
        [].forEach.call(_formElement.querySelectorAll('input[required]'), setInputElementDirty);
    }

    function buildErrorMessageElement(message) {
        var element = document.createElement('div');
        element.className = _snippetConfig.classNames.errorMessage;
        element.innerText = message;

        return element;
    }

    function setErrorState(element, message) {
        if (element.classList.contains(_snippetConfig.classNames.error)) {
            return;
        }

        element.classList.add(_snippetConfig.classNames.error);

        var errorMessageElement = buildErrorMessageElement(message);
        element.appendChild(errorMessageElement);
    }

    function removeElement(element) {
        element.parentElement.removeChild(element);
    }

    function removeErrorMessages(element) {
        [].forEach.call(element.querySelectorAll('.' + _snippetConfig.classNames.errorMessage), removeElement);
    }

    function removeErrorState(element) {
        element.classList.remove(_snippetConfig.classNames.error);
        removeErrorMessages(element);
    }

    function updateFormState() {
        [].forEach.call(_formElement.querySelectorAll('input[required]'), function (element) {
            if (!validateInput(element)) {
                setErrorState(element.parentElement, _snippetConfig.text.requiredField);
            }
            else {
                removeErrorState(element.parentElement);
            }
        });

        _submitButtonElement.disabled = !validateInput(_usernameInputElement) || !validateInput(_passwordInputElement);

    }

    function validateInput(element) {
        return !element.classList.contains(_snippetConfig.classNames.dirty) || !!element.value;
    }

    function initializeFormValidation() {
        _submitButtonElement = document.getElementById(_snippetConfig.ids.loginSubmit);
        _submitButtonElement.addEventListener('click', onLoginSubmitClick);

        _usernameInputElement = document.getElementById(_snippetConfig.ids.usernameInput);
        _usernameInputElement.addEventListener('input', onInputChange);
        _passwordInputElement = document.getElementById(_snippetConfig.ids.passwordInput);
        _passwordInputElement.addEventListener('input', onInputChange);

        _formElement = document.getElementById(_snippetConfig.ids.form);
    }


    /** FORM SUBMISSION **/

    function onLoginSubmitClick(event) {
        setFormDirty();

        if (!validateInput(_usernameInputElement) || !validateInput(_passwordInputElement)) {
            updateFormState();
            return event.preventDefault();
        }
        removeErrorMessages(_formElement);

        if (!_snippetConfig.loginUsingAjax) {
            return;
        }

        submitLoginRequest(
            {
                username: _usernameInputElement.value,
                password: _passwordInputElement.value
            },
            onSubmitLoginRequestSuccess,
            onSubmitLoginRequestFailure);

        return event.preventDefault();
    }

    function onSubmitLoginRequestFailure(message) {
        removeErrorMessages(_formElement);

        var errorElement = buildErrorMessageElement(message);
        _formElement.appendChild(errorElement);
    }

    function onSubmitLoginRequestSuccess(redirectUrl) {
        if (!(_snippetConfig.loginRedirectUrl || redirectUrl)) {
            if (!_snippetConfig.apiHost) {
                return;
            }

            redirectUrl = joinUrl(_snippetConfig.apiHost, '/nidp');
        }

        window.location = _snippetConfig.loginRedirectUrl || redirectUrl;
    }

    function getSubmitLoginUrl() {
        return _snippetConfig.loginUrl || _contractConfiguration.login['submiturl'];
    }

    function submitLoginRequest(options, successCallback, failureCallback) {
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function () {
            if (this.readyState === 4) {
                clearLoadingState();

                if (this.status === 200) {
                    var matches = this.responseText.match(/top\.location\.href=['"](.+)['"];/);

                    // Successful login
                    if (matches) {
                        (_snippetConfig.loginSuccessCallback || successCallback)(matches[1]);
                    }
                    // Unsuccessful login attempt
                    else {
                        (_snippetConfig.loginFailureCallback || failureCallback)(_snippetConfig.text.loginFailedError);
                    }
                }
                // Request complete. Unknown error occurred
                else {
                    failureCallback(_snippetConfig.text.loginFailedError);
                }
            }
        };

        setLoadingState();

        xhr.open("POST", getSubmitLoginUrl(), true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
        xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
        xhr.withCredentials = true;
        xhr.send(
            'option=credential' +
            '&Ecom_User_ID=' + encodeURIComponent(options.username) +
            '&Ecom_Password=' + encodeURIComponent(options.password));
    }

    function setLoadingState() {
        _loginContainerElement.className += ' ' + _snippetConfig.classNames.loading;
    }

    function clearLoadingState() {
        var loadingClassNameRegex = new RegExp(_snippetConfig.classNames.loading, 'g');
        _loginContainerElement.className = _loginContainerElement.className.replace(loadingClassNameRegex, '');
    }


    /** CONFIGURATION **/

    var defaults = {
        apiHost: null,
        apiContractConfigurationPath: '/nidp/rest/v1/config/login',
        apiLoginPath: '/nidp/app/login',
        classNames: {
            authProviderList: 'nam-auth-provider-list',
            contract: 'nam-contract',
            dirty: 'nam-dirty',
            error: 'nam-error',
            errorMessage: 'nam-message',
            formActions: 'nam-actions',
            inputContainer: 'nam-input-container',
            loading: 'nam-loading',
            loadingContainer: 'nam-loading-container',
            loginContainer: 'nam-login-container'
        },
        ids: {
            form: 'nam-form',
            passwordInput: 'nam-password',
            usernameInput: 'nam-username',
            loginContainer: 'nam-login-container',
            loginSubmit: 'nam-login-submit'
        },
        loginUsingAjax: false,
        loginUrl: null,
        loginRedirectUrl: null,
        loginFailureCallback: null,
        loginSuccessCallback: null,
        parent: document.body,
        forgotPasswordUrl: null,
        forgotPasswordLinkNewTab: true,
        passwordLabelPlaceholder: true,
        registerUrl: null,
        registerLinkNewTab: false,
        socialAuthProviders: null,
        socialLinksNewTab: false,
        usernameLabelPlaceholder: true,
        text: {
            error: 'An error occurred',
            forgotPassword: 'Can\'t sign in?',
            loginFailedError: 'Login failed, please try again.',
            passwordLabel: null,
            requiredField: 'Required',
            register: 'Register',
            socialTitle: 'Or use a secure social account',
            submit: 'Sign In',
            title: 'Sign In',
            usernameLabel: null,
            loggedIn: 'Successfully logged in'
        }
    };

    function isObject(item) {
        return (item && typeof item === 'object' && !Array.isArray(item));
    }

    function mergeDeep(target, source) {
        for (var key in source) {
            if (!source.hasOwnProperty(key)) {
                continue;
            }

            var obj = {};
            if (isObject(source[key])) {
                if (!target[key]) {
                    obj[key] = {};
                    Object.assign(target, obj);
                }

                mergeDeep(target[key], source[key]);
            }
            else {
                obj[key] = source[key];
                Object.assign(target, obj);
            }
        }

        return target;
    }


    /** ENTRY POINT **/

    function main(options) {
        _snippetConfig = mergeDeep(defaults, options || {});

        _loginContainerElement = buildContainer();

        var parent = getParentElement();
        parent.appendChild(_loginContainerElement);

        if (isAuthenticated) {
            return handleAuthenticatedUser();
        }

        if (!_snippetConfig.apiHost) {
            loadForm();
        }
        else {
            fetchContractConfiguration(onFetchContractConfigurationSuccess, onFetchContractConfigurationFailure);
        }
    }

    window.namLogin = main;
})(window, document);

