/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nam.custom.policy.condition;

import com.novell.nxpe.NxpeCondition;
import com.novell.nxpe.NxpeException;
import com.novell.nxpe.NxpeInformationContext;
import com.novell.nxpe.NxpeParameter;
import com.novell.nxpe.NxpeParameterList;
import com.novell.nxpe.NxpeResponseContext;
import com.novell.nxpe.NxpeResult;

public class PolicyConditionExtnTemplate
implements NxpeCondition {
    private String interfaceID;
    private boolean debug;
    private NxpeParameterList configurationValues;
    private static final String DEBUG_NAME = "Debug";
    private static final int EV_DEBUG = 91;
    private static final String LDAP_USER_DN_NAME = "LDAP User DN";
    private static final int EV_LDAP_USER_DN = 41;

    public void initialize(NxpeParameterList nxpeParameterList) throws NxpeException {
        this.configurationValues = nxpeParameterList;
        this.debug = true;
        this.setDebug(nxpeParameterList);
    }

    public void setInterfaceId(String string) throws NxpeException {
        this.interfaceID = string;
    }

    public NxpeResult evaluate(NxpeInformationContext nxpeInformationContext, NxpeResponseContext nxpeResponseContext) throws NxpeException {
        String string = "";
        NxpeResult nxpeResult = NxpeResult.ConditionFalse;
        if (this.debug) {
            System.out.println("PolicyConditionExtnTemplate : executing evaluate() of PolicyConditionExtnTemplate policy");
        }
        try {
            string = this.getLDAPUserDN(nxpeInformationContext);
            if (string != null && !string.isEmpty()) {
                if (this.debug) {
                    System.out.println("PolicyConditionExtnTemplate :strLDAPUserDN" + string);
                }
                nxpeResult = NxpeResult.ConditionTrue;
            } else {
                nxpeResult = NxpeResult.ConditionFalse;
            }
        }
        catch (NxpeException nxpeException) {
            if (this.debug) {
                nxpeException.printStackTrace();
            }
            nxpeResult = NxpeResult.ConditionFalse;
        }
        if (this.debug) {
            System.out.println(" PolicyConditionExtnTemplate : Exiting...");
        }
        return nxpeResult;
    }

    private void setDebug(NxpeParameterList nxpeParameterList) throws NxpeException {
        NxpeParameter nxpeParameter = nxpeParameterList.getParameter(91);
        if (nxpeParameter != null) {
            this.debug = Boolean.parseBoolean(nxpeParameter.getValue());
            System.out.println("PolicyConditionExtnTemplate : Debug : " + this.debug);
        }
    }

    private String getLDAPUserDN(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(41);
        if (nxpeParameter != null) {
            String string = (String)nxpeInformationContext.getData(nxpeParameter);
            if (this.debug) {
                System.out.println("PolicyConditionExtnTemplate : LDAP User DN : " + string);
            }
            return string;
        }
        NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, "PolicyConditionExtnTemplate :LDAP User DN: not present.");
        throw nxpeException;
    }
}

