/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nam.custom.policy.data;

import com.novell.nxpe.NxpeContextDataElement;
import com.novell.nxpe.NxpeException;
import com.novell.nxpe.NxpeInformationContext;
import com.novell.nxpe.NxpeParameter;
import com.novell.nxpe.NxpeParameterList;
import com.novell.nxpe.NxpeResponseContext;
import com.novell.nxpe.NxpeResult;
import java.util.Hashtable;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public final class LDAPGroupDataElement
implements NxpeContextDataElement {
    private static final String USER_STORE_NAME = "User Store";
    private static final int EV_USER_STORE = 11;
    private static final String AUTHENTICATION_NAME = "Authentication";
    private static final int EV_AUTHENTICATION = 211;
    private static final String DEFAULT_AUTHENTICATION = "simple";
    private static final String DIRECTORY_TYPE_NAME = "Directory Type";
    private static final int EV_DIRECTORY_TYPE = 222;
    private static final String DEFAULT_DIRECTORY_TYPE = "unknown";
    private static final String PROVIDER_URL_NAME = "User Store Replica";
    private static final int EV_PROVIDER_URL = 31;
    private static final String DEFAULT_PROVIDER_URL = "ldap://localhost:389";
    private static final String LDAP_USER_DN_NAME = "LDAP User DN";
    private static final int EV_LDAP_USER_DN = 41;
    private static final String SECURITY_PRINCIPAL_NAME = "Security Principal";
    private static final int EV_SECURITY_PRINCIPAL = 51;
    private static final String SECURITY_CREDENTIALS_NAME = "Security Credentials";
    private static final int EV_SECURITY_CREDENTIALS = 52;
    private static final String SEARCH_CONTEXT_NAME = "Search Context";
    private static final int EV_SEARCH_CONTEXT = 61;
    private static final String DEBUG_NAME = "Debug";
    private static final int EV_DEBUG = 91;
    private static final String CLS_GROUP = "group";
    private static final String CLS_GROUPOFNAMES = "groupofnames";
    private static final String CLS_GROUPOFUNIQUENAMES = "groupofuniquenames";
    private static final String ATTR_CN = "cn";
    private final String strName;
    private final int iEnumerativeValue;
    private final String strParameter;
    private NxpeParameterList configurationValues;
    private boolean debug;
    private String strUserStore;
    private String strProviderURL;
    private String strAuthentication;
    private String strDirectoryType;
    private String strLdapFilter;
    private SearchControls searchControls;

    public LDAPGroupDataElement(String string, int n, String string2) throws NxpeException {
        this.strName = string;
        this.iEnumerativeValue = n;
        this.strParameter = string2;
    }

    public void initialize(NxpeParameterList nxpeParameterList) throws NxpeException {
        this.configurationValues = nxpeParameterList;
        this.setDebug(nxpeParameterList);
        this.strProviderURL = DEFAULT_PROVIDER_URL;
        this.strAuthentication = DEFAULT_AUTHENTICATION;
        this.strDirectoryType = DEFAULT_DIRECTORY_TYPE;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("(|(objectClass=");
        stringBuffer.append(CLS_GROUP);
        stringBuffer.append(")(objectClass=");
        stringBuffer.append(CLS_GROUPOFNAMES);
        stringBuffer.append(")(objectClass=");
        stringBuffer.append(CLS_GROUPOFUNIQUENAMES);
        stringBuffer.append("))");
        this.strLdapFilter = new String(stringBuffer);
        this.searchControls = new SearchControls();
        this.searchControls.setTimeLimit(0);
        this.searchControls.setReturningObjFlag(true);
        this.searchControls.setSearchScope(2);
        this.searchControls.setReturningAttributes(new String[]{ATTR_CN});
    }

    public int getEnumerativeValue() {
        return this.iEnumerativeValue;
    }

    public String getName() {
        return this.strName;
    }

    public String getParameter() {
        return this.strParameter;
    }

    public synchronized Object getValue(NxpeInformationContext nxpeInformationContext, NxpeResponseContext nxpeResponseContext) throws NxpeException {
        LdapContext ldapContext = null;
        this.setUserStore(nxpeInformationContext);
        this.setProviderURL(nxpeInformationContext);
        this.setAuthentication(nxpeInformationContext);
        this.setDirectoryType(nxpeInformationContext);
        String string = this.getLDAPUserDN(nxpeInformationContext);
        String string2 = this.getSecurityPrincipal(nxpeInformationContext);
        if (string == null) {
            string = string2;
        }
        String string3 = this.getSecurityCredentials(nxpeInformationContext);
        String string4 = this.getSearchContext(nxpeInformationContext);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("(&(|(member=");
        stringBuffer.append(string);
        stringBuffer.append(")");
        stringBuffer.append("(uniqueMember=");
        stringBuffer.append(string);
        stringBuffer.append("))");
        stringBuffer.append(this.strLdapFilter);
        stringBuffer.append(")");
        String string5 = new String(stringBuffer);
        try {
            Object object;
            String string6 = "";
            ldapContext = this.newInitialLdapContext(string2, string3);
            NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(string4, string5, this.searchControls);
            while (namingEnumeration.hasMore()) {
                object = namingEnumeration.next();
                String string7 = ((NameClassPair)object).getNameInNamespace();
                string6 = string6 + string7 + "    ";
                if (!this.debug) continue;
                System.out.println("LDAPGroupDataElement: \"" + string7 + "\"");
            }
            object = string6;
            return object;
        }
        catch (NamingException namingException) {
            if (this.debug) {
                namingException.printStackTrace();
            }
            throw new NxpeException(NxpeResult.ErrorDataUnavailable, (Throwable)namingException);
        }
        finally {
            block13: {
                if (ldapContext != null) {
                    try {
                        ldapContext.close();
                    }
                    catch (NamingException namingException) {
                        if (!this.debug) break block13;
                        System.out.println(namingException.getMessage());
                    }
                }
            }
        }
    }

    private String getLDAPUserDN(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(41);
        if (nxpeParameter != null) {
            String string = (String)nxpeInformationContext.getData(nxpeParameter);
            if (this.debug) {
                System.out.println("LDAP User DN: " + string);
            }
            return string;
        }
        if (this.debug) {
            System.out.println("LDAP User DN: not present.");
        }
        return null;
    }

    private String getSecurityPrincipal(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(51);
        if (nxpeParameter == null) {
            NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, "Security Principal: not present.");
            if (this.debug) {
                nxpeException.printStackTrace();
            }
            throw nxpeException;
        }
        String string = (String)nxpeInformationContext.getData(nxpeParameter);
        if (this.debug) {
            System.out.println("Security Principal: " + string);
        }
        return string;
    }

    private String getSecurityCredentials(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(52);
        nxpeParameter = this.configurationValues.getParameter(52);
        if (nxpeParameter == null) {
            NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, "Security Credentials: not present.");
            if (this.debug) {
                nxpeException.printStackTrace();
            }
            throw nxpeException;
        }
        String string = (String)nxpeInformationContext.getData(nxpeParameter);
        if (this.debug) {
            System.out.println("Security Credentials: " + string);
        }
        return string;
    }

    private String getSearchContext(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        String string = "";
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(61);
        if (nxpeParameter != null) {
            string = (String)nxpeInformationContext.getData(nxpeParameter);
        }
        if (this.debug) {
            System.out.println("Search Context: \"" + string + "\"");
        }
        return string;
    }

    private void setUserStore(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(11);
        if (nxpeParameter != null) {
            this.strUserStore = (String)nxpeInformationContext.getData(nxpeParameter);
            if (this.debug) {
                System.out.println("User Store: " + this.strUserStore);
            }
        }
    }

    private void setProviderURL(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(31);
        if (nxpeParameter != null) {
            this.strProviderURL = (String)nxpeInformationContext.getData(nxpeParameter);
        }
        if (this.debug) {
            System.out.println("User Store Replica: " + this.strProviderURL);
        }
    }

    private void setDirectoryType(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(222);
        if (nxpeParameter != null) {
            this.strDirectoryType = (String)nxpeInformationContext.getData(nxpeParameter);
        }
        if (this.debug) {
            System.out.println("Directory Type: " + this.strDirectoryType);
        }
    }

    private void setAuthentication(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(211);
        if (nxpeParameter != null) {
            this.strAuthentication = (String)nxpeInformationContext.getData(nxpeParameter);
        }
        if (this.debug) {
            System.out.println("Authentication: " + this.strAuthentication);
        }
    }

    private void setDebug(NxpeParameterList nxpeParameterList) throws NxpeException {
        NxpeParameter nxpeParameter = nxpeParameterList.getParameter(91);
        if (nxpeParameter != null) {
            this.debug = Boolean.parseBoolean(nxpeParameter.getValue());
            System.out.println("Debug: " + this.debug);
        }
    }

    private LdapContext newInitialLdapContext(String string, String string2) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", this.strProviderURL);
        if (this.strProviderURL.startsWith("ldaps://")) {
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.security.authentication", this.strAuthentication);
        hashtable.put("java.naming.security.principal", string);
        hashtable.put("java.naming.security.credentials", string2);
        hashtable.put("java.naming.referral", "follow");
        InitialLdapContext initialLdapContext = new InitialLdapContext(hashtable, null);
        return initialLdapContext;
    }
}

