/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nam.custom.policy.data;

import com.novell.nxpe.CustomParameter;
import com.novell.nxpe.NxpeContextDataElement;
import com.novell.nxpe.NxpeException;
import com.novell.nxpe.NxpeInformationContext;
import com.novell.nxpe.NxpeParameter;
import com.novell.nxpe.NxpeParameterList;
import com.novell.nxpe.NxpeResponseContext;
import com.novell.nxpe.NxpeResult;

public class NameAttributeFromMailID
implements NxpeContextDataElement {
    private static final String LDAP_USER_MAIL = "LDAP User email";
    private static final int EV_LDAP_USER_MAIL = 71;
    private static final String DEBUG_NAME = "Debug";
    private static final int EV_DEBUG = 91;
    private final String strName;
    private final int iEnumerativeValue;
    private final String strParameter;
    private boolean debug;
    private NxpeParameterList configurationValues;

    public NameAttributeFromMailID(String string, int n, String string2) {
        this.strName = string;
        this.iEnumerativeValue = n;
        this.strParameter = string2;
    }

    public void initialize(NxpeParameterList nxpeParameterList) throws NxpeException {
        this.configurationValues = nxpeParameterList;
        this.setDebug(nxpeParameterList);
    }

    public int getEnumerativeValue() {
        return this.iEnumerativeValue;
    }

    public String getName() {
        return this.strName;
    }

    public String getParameter() {
        return this.strParameter;
    }

    public Object getValue(NxpeInformationContext nxpeInformationContext, NxpeResponseContext nxpeResponseContext) throws NxpeException {
        this.debug = true;
        CustomParameter customParameter = new CustomParameter(CustomParameter.ATTRIBUTE_VALUE);
        System.out.println("FADE: Attribute that we are looking at is " + nxpeInformationContext.getData((NxpeParameter)customParameter));
        String string = this.getLDAPUserMail(nxpeInformationContext);
        if (string == null) {
            if (this.debug) {
                System.out.println(" FADE : Mail is not configured properly for this class extention ");
            }
            return "Email not configured";
        }
        System.out.println(" FADE : name in email is " + string.substring(0, string.indexOf(64)));
        return string.substring(0, string.indexOf(64));
    }

    private void setDebug(NxpeParameterList nxpeParameterList) throws NxpeException {
        NxpeParameter nxpeParameter = nxpeParameterList.getParameter(91);
        if (nxpeParameter != null) {
            this.debug = Boolean.parseBoolean(nxpeParameter.getValue());
            System.out.println("Debug: " + this.debug);
        }
    }

    private String getLDAPUserMail(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(71);
        if (nxpeParameter == null) {
            NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, "LDAP User email: not present.");
            if (this.debug) {
                nxpeException.printStackTrace();
            }
            throw nxpeException;
        }
        Object object = nxpeInformationContext.getData(nxpeParameter);
        String string = null;
        string = object instanceof String[] ? ((String[])object)[0] : (String)object;
        if (object == null || string == null) {
            System.out.println("FADE : LDAP User email: Not Available for the user");
            NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, "LDAP User email: not present for the user.");
            throw nxpeException;
        }
        if (this.debug) {
            System.out.println("LDAP User email: " + string);
        }
        return string;
    }
}

