/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nam.custom.policy.data;

import com.novell.nxpe.NxpeContextDataElement;
import com.novell.nxpe.NxpeException;
import com.novell.nxpe.NxpeInformationContext;
import com.novell.nxpe.NxpeParameter;
import com.novell.nxpe.NxpeParameterList;
import com.novell.nxpe.NxpeResponseContext;
import com.novell.nxpe.NxpeResult;

public class PolicyDataExtnTemplate
implements NxpeContextDataElement {
    private static final String LDAP_USER_DN_NAME = "LDAP User DN";
    private static final int EV_LDAP_USER_DN = 41;
    private static final String DEBUG_NAME = "Debug";
    private static final int EV_DEBUG = 91;
    private final String strName;
    private final int iEnumerativeValue;
    private final String strParameter;
    private boolean debug;
    private NxpeParameterList configurationValues;
    private boolean singleInstance = false;

    public PolicyDataExtnTemplate(String string, int n, String string2) {
        this.strName = string;
        this.iEnumerativeValue = n;
        this.strParameter = string2;
    }

    public void initialize(NxpeParameterList nxpeParameterList) throws NxpeException {
        this.configurationValues = nxpeParameterList;
        this.debug = true;
        this.setDebug(nxpeParameterList);
    }

    public int getEnumerativeValue() {
        return this.iEnumerativeValue;
    }

    public String getName() {
        return this.strName;
    }

    public String getParameter() {
        return this.strParameter;
    }

    public Object getValue(NxpeInformationContext nxpeInformationContext, NxpeResponseContext nxpeResponseContext) throws NxpeException {
        String string = " Default";
        if (this.debug) {
            System.out.println("PolicyDataExtnTemplate : executing getValue() of PolicyDataExtnTemplate policy");
        }
        try {
            String string2 = "";
            string2 = this.getLDAPUserDN(nxpeInformationContext);
            if (string2 != null && !string2.isEmpty()) {
                if (this.debug) {
                    System.out.println("PolicyDataExtnTemplate :strLDAPUserDN" + string2);
                }
                string = "A";
            } else {
                string = "B";
            }
        }
        catch (NxpeException nxpeException) {
            if (this.debug) {
                nxpeException.printStackTrace();
            }
            string = "Default";
        }
        if (this.debug) {
            System.out.println("PolicyDataExtnTemplate : Exiting...");
        }
        return string;
    }

    private void setDebug(NxpeParameterList nxpeParameterList) throws NxpeException {
        NxpeParameter nxpeParameter = nxpeParameterList.getParameter(91);
        if (nxpeParameter != null) {
            this.debug = Boolean.parseBoolean(nxpeParameter.getValue());
            System.out.println("PolicyDataExtnTemplate : Debug : " + this.debug);
        }
    }

    private String getLDAPUserDN(NxpeInformationContext nxpeInformationContext) throws NxpeException {
        NxpeParameter nxpeParameter = this.configurationValues.getParameter(41);
        if (nxpeParameter != null) {
            String string = (String)nxpeInformationContext.getData(nxpeParameter);
            if (this.debug) {
                System.out.println("PolicyDataExtnTemplate : LDAP User DN : " + string);
            }
            return string;
        }
        NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, "PolicyDataExtnTemplate :LDAP User DN: not present.");
        throw nxpeException;
    }
}

