/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nam.authentication;

import com.novell.nidp.NIDPPrincipal;
import com.novell.nidp.NIDPSession;
import com.novell.nidp.NIDPSessionData;
import com.novell.nidp.authentication.local.LocalAuthenticationClass;
import com.novell.nidp.authentication.local.PageToShow;
import com.novell.nidp.authentication.local.STSAuthenticationClass;
import com.novell.nidp.common.authority.PasswordExpiredException;
import com.novell.nidp.common.authority.PasswordExpiringException;
import com.novell.nidp.common.authority.UserAuthority;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.IUsernameToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordClass
extends LocalAuthenticationClass
implements STSAuthenticationClass {
    public PasswordClass(Properties properties, ArrayList<UserAuthority> arrayList) {
        super(properties, arrayList);
    }

    public String getType() {
        return "Password";
    }

    public void initializeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, NIDPSession nIDPSession, NIDPSessionData nIDPSessionData, boolean bl, String string) {
        super.initializeRequest(httpServletRequest, httpServletResponse, nIDPSession, nIDPSessionData, bl, string);
    }

    protected int doAuthenticate() {
        int n;
        if (!this.isFirstCallAfterPrevMethod() && (n = this.handlePostedData()) != 2) {
            return n;
        }
        String string = this.getProperty("JSP");
        if (string == null || string.length() == 0) {
            string = "login";
        }
        this.m_PageToShow = new PageToShow(string);
        this.m_PageToShow.addAttribute("url", this.getReturnURL() != null ? this.getReturnURL() : this.m_Request.getRequestURL().toString());
        if (this.getAuthnRequest() != null && this.getAuthnRequest().getTarget() != null) {
            this.m_PageToShow.addAttribute("target", this.getAuthnRequest().getTarget());
        }
        return 6;
    }

    private int handlePostedData() {
        String string = this.m_Request.getParameter("Ecom_User_ID");
        String string2 = this.m_Request.getParameter("Ecom_Password");
        String string3 = this.checkForQuery();
        try {
            if (string3 != null) {
                if (this.authenticateWithQuery(string3, string2)) {
                    return 0;
                }
            } else {
                if (string == null || string.length() == 0) {
                    return 2;
                }
                if (this.authenticateWithPassword(string, string2)) {
                    return 0;
                }
            }
        }
        catch (PasswordExpiringException passwordExpiringException) {
            return 4;
        }
        catch (PasswordExpiredException passwordExpiredException) {
            return 5;
        }
        this.m_Request.setAttribute("loginError", (Object)this.getUserErrorMsg());
        return 2;
    }

    public NIDPPrincipal handleSTSAuthentication(ISecurityInformation iSecurityInformation) {
        IUsernameToken iUsernameToken = (IUsernameToken)iSecurityInformation.getFirst(IUsernameToken.class);
        if (null != iUsernameToken) {
            try {
                if (this.authenticateWithPassword(iUsernameToken.getUsername(), iUsernameToken.getPassword())) {
                    return this.getPrincipal();
                }
            }
            catch (PasswordExpiringException passwordExpiringException) {
                return this.getPrincipal();
            }
            catch (PasswordExpiredException passwordExpiredException) {
                // empty catch block
            }
        }
        return null;
    }
}

