/*
  Copyright (c) 2012 Novell, Inc. All Rights Reserved.

  Novell grants permission, free of charge, to any person obtaining copies
  of this software and its associated documentation files (the "Software"),
  to deal in the Software without restriction, including to use, copy, adapt, 
  publish, distribute, display, perform, sublicense, and sell copies of the 
  Software, subject to the following condition: You must include the above 
  copyright notice and this permission notice in all full or partial copies 
  of the Software.

  NOVELL PROVIDES THE SOFTWARE "AS IS," WITHOUT ANY EXPRESS OR IMPLIED WARRANTY,
  INCLUDING WITHOUT THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  PARTICULAR PURPOSE, AND NON-INFRINGMENT.  NOVELL, THE AUTHORS OF THE SOFTWARE,
  AND THE OWNERS OF COPYRIGHT IN THE SOFTWARE ARE NOT LIABLE FOR ANY CLAIM, DAMAGES,
  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT, OR OTHERWISE, ARISING
  FROM, OUT OF, OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */


package com.novell.nam.custom.policy.data;

import com.novell.nxpe.CustomParameter;
import com.novell.nxpe.NxpeContextDataElement;
import com.novell.nxpe.NxpeException;
import com.novell.nxpe.NxpeInformationContext;
import com.novell.nxpe.NxpeParameter;
import com.novell.nxpe.NxpeParameterList;
import com.novell.nxpe.NxpeResponseContext;
import com.novell.nxpe.NxpeResult;


/* This is an example code for returning a name of the user from user email
  Eg: myname@novell.com will be passed as a LDAP Attribute:mail parameter 
  and this class will return the myname as the value to a configured attribute.
 */
public class NameAttributeFromMailID implements NxpeContextDataElement {

    /*                ----BEGIN----
     * Initializing the constants for parameters passed to this class
     * Configuration parameter can be configured from the administrator
     * console UI. Go to Policies Tab->Extensions-><class extention>
     * ->Configuration Parameters:->New
     */
   
    /* Name parameter is used for reference in the code, can be used for logging. 
     * EV(Enumeration Value) will be used for fetching the parameter.
     * This number must match the number configured at UI as ID parameter
     */

    /* This parameter is  LDAP Attribute:mail */
    private static final String LDAP_USER_MAIL = "LDAP User email";
    private static final int EV_LDAP_USER_MAIL = 71;

    /* This parameter is a string constant */
    private static final String DEBUG_NAME = "Debug";
    private static final int EV_DEBUG = 91;    
	
    /*                ----END----                                             */
	

    // NxpeContextDataElement values
    private final String strName;
    private final int iEnumerativeValue;
    private final String strParameter;
    private boolean debug;

    /* NxpeParameterList will be initialized during inialize() call */
    private NxpeParameterList configurationValues;

    /* Constructor. Called by FileAttributeDataElementFactory class  */
        public NameAttributeFromMailID( String name, int enumerationValue, String parameter ) {
            strName = name;
            iEnumerativeValue = enumerationValue;
            strParameter = parameter;
        }

	/* Initialize the configuration values */
 	@Override
	public void initialize(NxpeParameterList configurationValues) 
			throws NxpeException {
		this.configurationValues = configurationValues;

		setDebug(configurationValues);

	}
	   
	@Override
	public int getEnumerativeValue() {
		return iEnumerativeValue;
	}

	@Override
	public String getName() {
		return strName;
	}

	@Override
	public String getParameter() {
		return strParameter;
	}

	@Override
	public Object getValue(NxpeInformationContext informationContext, 
				NxpeResponseContext responseContext )
			throws NxpeException {

		debug = true;
		
		/* Create a CustomParameter object to fetch the name of the attribute from the Engine. */
		NxpeParameter customParam = new CustomParameter(CustomParameter.ATTRIBUTE_VALUE);
		System.out.println("FADE: Attribute that we are looking at is " + informationContext.getData(customParam));

		
		/* Below code is an example of fetching email of the user configured
		 * returning one of them
		 */

		String strEMail = getLDAPUserMail(informationContext);

		if (strEMail == null)
		{
			if (debug)
			    System.out.println(" FADE : Mail is not configured properly for this class extention ");
			return "Email not configured";
		}
		
		System.out.println(" FADE : name in email is " +  strEMail.substring(0, strEMail.indexOf('@')));
		return strEMail.substring(0, strEMail.indexOf('@'));
	}


    /**
     * Optional:
     * 
     * @param configurationValues
     * 
     * @throws com.novell.nxpe.NxpeException
     */
    private void setDebug(
            NxpeParameterList configurationValues)
        throws NxpeException
    {
        NxpeParameter parameter = configurationValues.getParameter(EV_DEBUG);

        if (parameter != null)
        {
            debug = Boolean.parseBoolean(parameter.getValue());
            System.out.println("Debug: " + debug);
        }
    }	

    /**
     * Required:
     * 
     * @param informationContext
     * 
     * @return
     * 
     * @throws com.novell.nxpe.NxpeException
     */
    private String getLDAPUserMail(
            NxpeInformationContext informationContext)
        throws NxpeException
    {
        NxpeParameter pUserMail;

        if ((pUserMail = configurationValues.getParameter(EV_LDAP_USER_MAIL)) == null)
        {
            NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, LDAP_USER_MAIL + ": not present.");

            if (debug)
            {
                nxpeException.printStackTrace();
            }

            throw (nxpeException);

        }

        Object strUserMailObj = informationContext.getData(pUserMail);
	String strUserMail = null;
	/* NOTE: If your data is multi valued, then assign to an array */
	if (strUserMailObj instanceof String[])
		strUserMail = ((String[])strUserMailObj)[0];
	else
		strUserMail = (String)strUserMailObj;
	if ( (strUserMailObj == null) || (strUserMail == null) )
	{
	    
            System.out.println("FADE : " + LDAP_USER_MAIL + ": Not Available for the user");
            NxpeException nxpeException = new NxpeException(NxpeResult.ErrorDataUnavailable, LDAP_USER_MAIL + ": not present for the user.");
            throw (nxpeException);
	}

        if (debug)
        {
            System.out.println(LDAP_USER_MAIL + ": " + strUserMail);
        }

        return strUserMail;

    }
}

